/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.notification;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.notification.NotificationException;
import org.jboss.soa.esb.util.ClassUtil;

public abstract class NotificationTarget {
    private static final String NOTIF_PFX = NotificationTarget.class.getPackage().getName();
    public static final String PRM_NOTIF_CLASS = "class";
    protected ConfigTree m_oParms;

    public abstract void sendNotification(Message var1) throws NotificationException;

    protected NotificationTarget() {
    }

    protected NotificationTarget(ConfigTree p_oP) {
        this.m_oParms = p_oP;
    }

    public static NotificationTarget fromParams(ConfigTree p_oP) throws ConfigurationException {
        String sClass = p_oP.getAttribute(PRM_NOTIF_CLASS);
        if (null == sClass) {
            throw new IllegalArgumentException("Missing 'class' attribute in parameters");
        }
        Class oCls = null;
        try {
            oCls = ClassUtil.forName(NOTIF_PFX + "." + sClass, NotificationTarget.class);
        }
        catch (Exception e) {
            try {
                oCls = ClassUtil.forName(sClass, NotificationTarget.class);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        if (null == oCls) {
            throw new ConfigurationException("Invalid class <" + sClass + ">, or missing library");
        }
        Constructor oCons = null;
        try {
            oCons = oCls.getConstructor(ConfigTree.class);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null == oCons) {
            throw new ConfigurationException("No valid constructor " + sClass + "(ConfigTree)");
        }
        Object oRet = null;
        try {
            oRet = oCons.newInstance(p_oP);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            throw new ConfigurationException("Failed to create an instance of NotificationTarget class '" + sClass + "'.", cause != null ? cause : e);
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to create an instance of NotificationTarget class '" + sClass + "'.", e);
        }
        if (!(oRet instanceof NotificationTarget)) {
            throw new ConfigurationException(sClass + "  does not extend NotificationTarget");
        }
        return oRet;
    }
}

