/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.message.helper.content;

import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.message.body.content.MapBody;
import org.jboss.soa.esb.message.body.content.ObjectBody;
import org.jboss.soa.esb.message.body.content.TextBody;
import org.jboss.soa.esb.message.format.MessageFactory;

public class ContentManager {
    private URI _type;

    public Message createTextMessage(String initial) {
        if (initial == null) {
            throw new IllegalArgumentException();
        }
        Message msg = MessageFactory.getInstance().getMessage(this._type);
        try {
            TextBody payload = (TextBody)MessageFactory.getInstance().createBodyType(msg, "text");
            payload.setText(initial);
            return msg;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Message createObjectMessage(Serializable initial) {
        if (initial == null) {
            throw new IllegalArgumentException();
        }
        Message msg = MessageFactory.getInstance().getMessage(this._type);
        try {
            ObjectBody payload = (ObjectBody)MessageFactory.getInstance().createBodyType(msg, "object");
            payload.setObject(initial);
            return msg;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Message createMapMessage(Map<String, Serializable> initial) {
        if (initial == null) {
            throw new IllegalArgumentException();
        }
        Message msg = MessageFactory.getInstance().getMessage(this._type);
        try {
            MapBody payload = (MapBody)MessageFactory.getInstance().createBodyType(msg, "map");
            payload.setMap(initial);
            return msg;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Message createBytesMessage(byte[] initial) {
        if (initial == null) {
            throw new IllegalArgumentException();
        }
        Message msg = MessageFactory.getInstance().getMessage(this._type);
        try {
            BytesBody payload = (BytesBody)MessageFactory.getInstance().createBodyType(msg, "bytes");
            payload.add("org.jboss.soa.esb.message.content.bytes", initial);
            return msg;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected ContentManager(URI type) {
        this._type = type;
    }
}

