/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.lifecycle.LifecycleResource;
import org.jboss.soa.esb.lifecycle.LifecycleResourceException;
import org.jboss.soa.esb.lifecycle.LifecycleResourceFactory;
import org.jboss.soa.esb.lifecycle.LifecycleResourceManager;
import org.jboss.soa.esb.listeners.message.ServiceMessageCounter;

public class ServiceMessageCounterLifecycleResource {
    private static final LifecycleResourceFactory<Map<String, ServiceMessageCounter>> lifecycleServiceMessageCounterFactory = new LifecycleServiceMessageCounterFactory();
    private static final LifecycleResource<Map<String, ServiceMessageCounter>> lifecycleServiceMessageCounters = new LifecycleResource<Map<String, ServiceMessageCounter>>(lifecycleServiceMessageCounterFactory, 75000);
    private static final Logger LOGGER = Logger.getLogger(ServiceMessageCounterLifecycleResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceMessageCounter getServiceMessageCounter(ConfigTree configTree) throws LifecycleResourceException {
        Map<String, ServiceMessageCounter> contextCounters;
        String objectName = ServiceMessageCounterLifecycleResource.getObjectName(configTree);
        Map<String, ServiceMessageCounter> map = contextCounters = lifecycleServiceMessageCounters.getLifecycleResource();
        synchronized (map) {
            ServiceMessageCounter serviceMessageCounter = contextCounters.get(objectName);
            if (serviceMessageCounter != null) {
                return serviceMessageCounter;
            }
            ServiceMessageCounter newServiceMessageCounter = new ServiceMessageCounter(configTree, objectName);
            newServiceMessageCounter.registerMBean();
            contextCounters.put(objectName, newServiceMessageCounter);
            return newServiceMessageCounter;
        }
    }

    private static String getObjectName(ConfigTree configTree) {
        String categoryName = configTree.getAttribute("service-category");
        String serviceName = configTree.getAttribute("service-name");
        String targetCategoryName = configTree.getAttribute("target-service-category");
        String targetServiceName = configTree.getAttribute("target-service-name");
        LifecycleResourceManager lifecycleResourceManager = LifecycleResourceManager.getSingleton();
        String[] associatedDeployments = lifecycleResourceManager.getAssociatedDeployments();
        String deployment = associatedDeployments != null && associatedDeployments.length == 1 ? associatedDeployments[0] : lifecycleResourceManager.getIdentity();
        StringBuffer objectName = new StringBuffer("category=MessageCounter");
        ServiceMessageCounterLifecycleResource.append(objectName, "deployment", deployment);
        ServiceMessageCounterLifecycleResource.append(objectName, "service-category", categoryName);
        ServiceMessageCounterLifecycleResource.append(objectName, "service-name", serviceName);
        ServiceMessageCounterLifecycleResource.append(objectName, "target-service-category", targetCategoryName);
        ServiceMessageCounterLifecycleResource.append(objectName, "target-service-name", targetServiceName);
        return objectName.toString();
    }

    private static void append(StringBuffer objectName, String name, String value) {
        if (value != null && value.length() > 0) {
            objectName.append(",").append(name).append("=").append(value);
        }
    }

    private static class LifecycleServiceMessageCounterFactory
    implements LifecycleResourceFactory<Map<String, ServiceMessageCounter>> {
        private LifecycleServiceMessageCounterFactory() {
        }

        @Override
        public Map<String, ServiceMessageCounter> createLifecycleResource(String lifecycleIdentity) throws LifecycleResourceException {
            return new HashMap<String, ServiceMessageCounter>();
        }

        @Override
        public void destroyLifecycleResource(Map<String, ServiceMessageCounter> resource, String lifecycleIdentity) throws LifecycleResourceException {
            if (resource.size() > 0) {
                LOGGER.warn((Object)("Calling cleanup on existing service message counters for identity " + lifecycleIdentity));
                for (ServiceMessageCounter counter : resource.values()) {
                    counter.unregisterMBean();
                }
            }
        }
    }
}

