/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.actions.ActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.ActionProcessorMethodInfo;
import org.jboss.soa.esb.message.Message;

final class OverriddenActionPipelineProcessor
implements ActionPipelineProcessor {
    private final ActionProcessorMethodInfo methodInfo;
    private final ActionPipelineProcessor processor;

    OverriddenActionPipelineProcessor(ConfigTree config, ActionPipelineProcessor processor) throws ConfigurationException {
        this.processor = processor;
        this.methodInfo = ActionProcessorMethodInfo.getMethodInfo(config, processor.getClass());
    }

    @Override
    public Message process(Message message) throws ActionProcessingException {
        if (this.methodInfo.hasProcessMethods()) {
            return this.methodInfo.processMethods(this.processor, message);
        }
        return this.processor.process(message);
    }

    @Override
    public void processException(Message message, Throwable th) {
        if (this.methodInfo.hasProcessException()) {
            this.methodInfo.processException(this.processor, message, th);
        } else {
            this.processor.processException(message, th);
        }
    }

    @Override
    public void processSuccess(Message message) {
        if (this.methodInfo.hasProcessSuccess()) {
            this.methodInfo.processSuccess(this.processor, message);
        } else {
            this.processor.processSuccess(message);
        }
    }

    @Override
    public void initialise() throws ActionLifecycleException {
        this.processor.initialise();
    }

    @Override
    public void destroy() throws ActionLifecycleException {
        this.processor.destroy();
    }
}

