/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionLifecycle;
import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.actions.ActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.ActionProcessorMethodInfo;
import org.jboss.soa.esb.message.Message;

final class OverriddenActionLifecycleProcessor
implements ActionPipelineProcessor {
    private final ActionProcessorMethodInfo methodInfo;
    private final ActionLifecycle lifecycle;

    OverriddenActionLifecycleProcessor(ConfigTree config, ActionLifecycle lifecycle) throws ConfigurationException {
        this.lifecycle = lifecycle;
        this.methodInfo = ActionProcessorMethodInfo.getMethodInfo(config, lifecycle.getClass());
    }

    @Override
    public Message process(Message message) throws ActionProcessingException {
        if (this.methodInfo.hasProcessMethods()) {
            return this.methodInfo.processMethods(this.lifecycle, message);
        }
        return message;
    }

    @Override
    public void processException(Message message, Throwable th) {
        if (this.methodInfo.hasProcessException()) {
            this.methodInfo.processException(this.lifecycle, message, th);
        }
    }

    @Override
    public void processSuccess(Message message) {
        if (this.methodInfo.hasProcessSuccess()) {
            this.methodInfo.processSuccess(this.lifecycle, message);
        }
    }

    @Override
    public void initialise() throws ActionLifecycleException {
        this.lifecycle.initialise();
    }

    @Override
    public void destroy() throws ActionLifecycleException {
        this.lifecycle.destroy();
    }
}

