/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message;

import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.message.LegacyMessageComposerAdapter;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.util.ClassUtil;

public interface MessageComposer<T> {
    public void setConfiguration(ConfigTree var1) throws ConfigurationException;

    public Message compose(T var1) throws MessageDeliverException;

    public Object decompose(Message var1, T var2) throws MessageDeliverException;

    public static class Factory {
        public static MessageComposer getInstance(String className, ConfigTree config) throws ConfigurationException, MessageDeliverException {
            return Factory.getInstance(className, config, null);
        }

        public static MessageComposer getInstance(String className, ConfigTree config, Class legacyAdapterType) throws ConfigurationException {
            MessageComposer instance;
            AssertArgument.isNotNullAndNotEmpty(className, "className");
            AssertArgument.isNotNull(config, "config");
            try {
                instance = Factory.newComposerInstance(ClassUtil.forName(className, Factory.class));
            }
            catch (ClassCastException e) {
                if (legacyAdapterType == null) {
                    throw new ConfigurationException("Composer class [" + className + "] not an instance of '" + MessageComposer.class.getName() + "' and no " + LegacyMessageComposerAdapter.class.getSimpleName() + " specified.", e);
                }
                if (LegacyMessageComposerAdapter.class.isAssignableFrom(legacyAdapterType)) {
                    instance = Factory.newComposerInstance(legacyAdapterType);
                }
                throw new ConfigurationException("Legacy composer adapter class [" + legacyAdapterType.getName() + "] not an instance of '" + LegacyMessageComposerAdapter.class.getName() + "'.");
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Composer class [" + className + "] not found in classpath.", e);
            }
            instance.setConfiguration(config);
            return instance;
        }

        private static MessageComposer newComposerInstance(Class composerClass) throws ConfigurationException {
            try {
                return (MessageComposer)composerClass.newInstance();
            }
            catch (InstantiationException e) {
                if (composerClass.getEnclosingClass() != null) {
                    throw new ConfigurationException("Failed to instantiate composer class [" + composerClass.getName() + "].  This may be because it is not a top level class.", e);
                }
                throw new ConfigurationException("Failed to instantiate composer class [" + composerClass.getName() + "].", e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Failed to instantiate composer class [" + composerClass.getName() + "].", e);
            }
        }
    }
}

