/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message;

import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageComposer;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.message.format.MessageFactory;

public abstract class AbstractMessageComposer<T>
implements MessageComposer<T> {
    private ConfigTree configuration;
    private MessagePayloadProxy payloadProxy;

    @Override
    public void setConfiguration(ConfigTree config) {
        this.configuration = config;
        this.payloadProxy = new MessagePayloadProxy(config, new String[]{"org.jboss.soa.esb.actions.post", "org.jboss.soa.esb.message.defaultEntry", "org.jboss.soa.esb.message.content.bytes"}, new String[]{"org.jboss.soa.esb.message.defaultEntry"});
    }

    public ConfigTree getConfiguration() {
        return this.configuration;
    }

    @Override
    public Message compose(T messagePayload) throws MessageDeliverException {
        Message message = MessageFactory.getInstance().getMessage();
        this.populateMessage(message, messagePayload);
        return message;
    }

    protected MessagePayloadProxy getPayloadProxy() {
        return this.payloadProxy;
    }

    @Override
    public Object decompose(Message message, T originalInputMessagePayload) throws MessageDeliverException {
        return this.getPayloadProxy().getPayload(message);
    }

    protected abstract void populateMessage(Message var1, T var2) throws MessageDeliverException;
}

