/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.lifecycle;

public enum ManagedLifecycleState {
    CONSTRUCTED{

        @Override
        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == INITIALISING;
        }
    }
    ,
    INITIALISING{

        @Override
        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == INITIALISED || newState == DESTROYED;
        }
    }
    ,
    INITIALISED{

        @Override
        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == STARTING || newState == DESTROYING;
        }
    }
    ,
    STARTING{

        @Override
        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == STARTED || newState == STOPPED;
        }
    }
    ,
    STARTED{

        @Override
        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == RUNNING || newState == STOPPING;
        }
    }
    ,
    RUNNING{

        @Override
        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == STOPPING;
        }
    }
    ,
    STOPPING{

        @Override
        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == STOPPED;
        }
    }
    ,
    STOPPED{

        @Override
        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == STARTING || newState == DESTROYING;
        }
    }
    ,
    DESTROYING{

        @Override
        public boolean canTransition(ManagedLifecycleState newState) {
            return newState == DESTROYED;
        }
    }
    ,
    DESTROYED{

        @Override
        public boolean canTransition(ManagedLifecycleState newState) {
            return false;
        }
    };


    public abstract boolean canTransition(ManagedLifecycleState var1);
}

