/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.lifecycle;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;

public class ManagedLifecycleController {
    private Logger log = Logger.getLogger(ManagedLifecycleController.class);
    private final ManagedLifecycle[] instances;

    public ManagedLifecycleController(Collection<ManagedLifecycle> lifecycles) {
        this.instances = lifecycles == null ? new ManagedLifecycle[0] : lifecycles.toArray(new ManagedLifecycle[lifecycles.size()]);
    }

    public void start() throws ManagedLifecycleException {
        this.initialiseInstances();
        this.startInstances();
    }

    public void restart() throws ManagedLifecycleException {
        this.stopInstances();
        this.startInstances();
    }

    public void stop() throws ManagedLifecycleException {
        this.stopAndDestroy(true);
    }

    private void initialiseInstances() throws ManagedLifecycleException {
        int numInstances = this.instances.length;
        for (int count = 0; count < numInstances; ++count) {
            ManagedLifecycle instance = this.instances[count];
            try {
                instance.initialise();
                continue;
            }
            catch (ManagedLifecycleException mle) {
                if (count > 0) {
                    this.destroyInstances(count - 1);
                }
                throw mle;
            }
        }
    }

    private void startInstances() throws ManagedLifecycleException {
        int numInstances = this.instances.length;
        for (int count = 0; count < numInstances; ++count) {
            ManagedLifecycle instance = this.instances[count];
            try {
                instance.start();
                continue;
            }
            catch (ManagedLifecycleException mle) {
                if (count > 0) {
                    this.stopInstances(count - 1);
                    this.destroyInstances(numInstances - 1);
                }
                throw mle;
            }
        }
    }

    private void stopInstances() throws ManagedLifecycleException {
        int numInstances = this.instances.length;
        for (int count = numInstances - 1; count >= 0; --count) {
            ManagedLifecycle instance = this.instances[count];
            try {
                instance.stop();
                continue;
            }
            catch (ManagedLifecycleException mle) {
                if (count > 0) {
                    this.stopInstances(count - 1);
                    this.destroyInstances(numInstances - 1);
                }
                throw mle;
            }
        }
    }

    private void destroyInstances() throws ManagedLifecycleException {
        int numInstances = this.instances.length;
        for (int count = numInstances - 1; count >= 0; --count) {
            ManagedLifecycle instance = this.instances[count];
            try {
                instance.destroy();
                continue;
            }
            catch (ManagedLifecycleException mle) {
                if (count > 0) {
                    this.destroyInstances(count - 1);
                }
                throw mle;
            }
        }
    }

    private void stopInstances(int firstInstance) {
        for (int count = firstInstance; count >= 0; --count) {
            ManagedLifecycle instance = this.instances[count];
            try {
                instance.stop();
                continue;
            }
            catch (ManagedLifecycleException mle) {
                this.log.error((Object)mle.getMessage(), (Throwable)mle);
            }
        }
    }

    private void destroyInstances(int firstInstance) {
        for (int count = firstInstance; count >= 0; --count) {
            ManagedLifecycle instance = this.instances[count];
            try {
                instance.destroy();
                continue;
            }
            catch (ManagedLifecycleException mle) {
                // empty catch block
            }
        }
    }

    private void stopAndDestroy(boolean throwExceptions) throws ManagedLifecycleException {
        if (throwExceptions) {
            this.stopInstances();
            this.destroyInstances();
        } else {
            int numInstances = this.instances.length;
            this.stopInstances(numInstances - 1);
            this.destroyInstances(numInstances - 1);
        }
    }
}

