/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.lifecycle;

import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.lifecycle.LifecycleResourceManager;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleAdapter;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;

public class LifecycleController
implements DynamicMBean {
    private ManagedLifecycleAdapter m_lifecycle;
    private String m_startTime;
    private final ObjectName listObjectName;
    private final ClassLoader tccl;
    private static final Logger logger = Logger.getLogger(LifecycleController.class);
    public static final String LIFECYCLESTATE_ATTRIB = "LifeCycleState";
    public static final String STARTTIME_ATTRIB = "StartDate";
    public static final String XML_ATTRIB = "ListenerXMLAsHtml";
    public static final String START_ACTION = "start";
    public static final String STOP_ACTION = "stop";

    public LifecycleController(ManagedLifecycleAdapter f_lifecycle) {
        this.m_lifecycle = f_lifecycle;
        this.m_startTime = "";
        this.listObjectName = this.getObjectName();
        this.tccl = Thread.currentThread().getContextClassLoader();
    }

    protected void setStartTime(long f_startTime) {
        Timestamp ts = new Timestamp(f_startTime);
        this.m_startTime = ts.toString();
    }

    protected void unsetStartTime() {
        this.m_startTime = "";
    }

    public void setLifecycle(ManagedLifecycleAdapter f_aml) {
        this.m_lifecycle = f_aml;
    }

    public String getListenerXMLAsHtml() {
        return this.m_lifecycle.getConfig().toXml().replace("<", "&lt;").replace(">", "&gt;");
    }

    public void start() throws ManagedLifecycleException {
        this.m_lifecycle.start();
    }

    public void stop() throws ManagedLifecycleException {
        this.m_lifecycle.stop();
    }

    protected void registerMBean() {
        if (this.listObjectName == null) {
            return;
        }
        MBeanServer mbeanServer = null;
        try {
            mbeanServer = MBeanServerLocator.locateJBoss();
        }
        catch (IllegalStateException ise) {
            return;
        }
        try {
            mbeanServer.registerMBean(this, this.listObjectName);
        }
        catch (InstanceAlreadyExistsException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected void unregisterMBean() {
        if (this.listObjectName == null) {
            return;
        }
        MBeanServer mbeanServer = null;
        try {
            mbeanServer = MBeanServerLocator.locateJBoss();
        }
        catch (IllegalStateException ise) {
            return;
        }
        try {
            mbeanServer.unregisterMBean(this.listObjectName);
        }
        catch (InstanceNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public AttributeList getAttributes(String[] arg0) {
        ConfigTree config = this.m_lifecycle.getConfig();
        AttributeList attributeList = new AttributeList();
        Set<String> set = config.getAttributeNames();
        String[] attribs = set.toArray(new String[set.size()]);
        for (int i = 0; i < attribs.length; ++i) {
            Attribute at = new Attribute(attribs[i], config.getAttribute(attribs[i]));
            attributeList.add(at);
        }
        Attribute lifecycleState = new Attribute(LIFECYCLESTATE_ATTRIB, this.m_lifecycle.getState().toString());
        attributeList.add(lifecycleState);
        Attribute startTimeAttrib = new Attribute(STARTTIME_ATTRIB, this.m_startTime);
        attributeList.add(startTimeAttrib);
        Attribute xmlAttrib = new Attribute(XML_ATTRIB, this.getListenerXMLAsHtml());
        attributeList.add(xmlAttrib);
        return attributeList;
    }

    @Override
    public synchronized String getAttribute(String name) throws AttributeNotFoundException {
        String value = null;
        value = name.equals(LIFECYCLESTATE_ATTRIB) ? this.m_lifecycle.getState().toString() : (name.equals(STARTTIME_ATTRIB) ? this.m_startTime : (name.equals(XML_ATTRIB) ? this.getListenerXMLAsHtml() : this.m_lifecycle.getConfig().getAttribute(name)));
        if (value != null) {
            return value;
        }
        throw new AttributeNotFoundException("No such property: " + name);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        TreeSet<String> names = new TreeSet<String>();
        for (String name : this.m_lifecycle.getConfig().getAttributeNames()) {
            names.add(name);
        }
        names.add(LIFECYCLESTATE_ATTRIB);
        names.add(STARTTIME_ATTRIB);
        names.add(XML_ATTRIB);
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[names.size()];
        Iterator it = names.iterator();
        for (int i = 0; i < attrs.length; ++i) {
            String name = (String)it.next();
            attrs[i] = new MBeanAttributeInfo(name, "java.lang.String", "Property " + name, true, false, false);
        }
        MBeanOperationInfo[] opers = new MBeanOperationInfo[]{new MBeanOperationInfo(START_ACTION, "Start the lifecycle", null, "void", 1), new MBeanOperationInfo(STOP_ACTION, "Stop the lifecycle", null, "void", 1)};
        return new MBeanInfo(this.getClass().getName(), "Lifecycle Controller MBean", attrs, null, opers, null);
    }

    @Override
    public Object invoke(String method, Object[] arg1, String[] arg2) throws ReflectionException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.tccl);
        try {
            if (method.equalsIgnoreCase(START_ACTION)) {
                try {
                    this.start();
                }
                catch (ManagedLifecycleException e) {
                    logger.error((Object)"", (Throwable)e);
                    String string = "Error invoking " + method + ": " + e.toString();
                    Thread.currentThread().setContextClassLoader(current);
                    return string;
                }
                String e = "Invoking the " + method + " on the lifecycle.";
                return e;
            }
            if (method.equalsIgnoreCase(STOP_ACTION)) {
                try {
                    this.stop();
                }
                catch (ManagedLifecycleException e) {
                    logger.error((Object)"", (Throwable)e);
                    String string = "Error invoking " + method + ": " + e.toString();
                    Thread.currentThread().setContextClassLoader(current);
                    return string;
                }
                String string = "Invoking the " + method + " on the lifecycle.";
                return string;
            }
            throw new ReflectionException(new NoSuchMethodException(method));
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public void setAttribute(Attribute arg0) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList setAttributes(AttributeList arg0) {
        return null;
    }

    protected ObjectName getObjectName() {
        ObjectName listObjectName = null;
        try {
            ConfigTree config = this.m_lifecycle.getConfig();
            String categoryName = config.getAttribute("service-category");
            String serviceName = config.getAttribute("service-name");
            String targetCategoryName = config.getAttribute("target-service-category");
            String targetServiceName = config.getAttribute("target-service-name");
            String listenerName = config.getAttribute("name");
            LifecycleResourceManager lifecycleResourceManager = LifecycleResourceManager.getSingleton();
            String[] associatedDeployments = lifecycleResourceManager.getAssociatedDeployments();
            String deployment = associatedDeployments != null && associatedDeployments.length == 1 ? associatedDeployments[0] : lifecycleResourceManager.getIdentity();
            StringBuffer objectName = new StringBuffer();
            this.append(objectName, "deployment", deployment);
            this.append(objectName, "service-category", categoryName);
            this.append(objectName, "service-name", serviceName);
            this.append(objectName, "target-service-category", targetCategoryName);
            this.append(objectName, "target-service-name", targetServiceName);
            if ("true".equals(config.getAttribute("is-gateway"))) {
                this.append(objectName, "gateway-name", listenerName);
            } else {
                this.append(objectName, "listener-name", listenerName);
            }
            listObjectName = new ObjectName("jboss.esb:" + objectName.toString());
        }
        catch (MalformedObjectNameException e1) {
            logger.error((Object)"", (Throwable)e1);
        }
        catch (NullPointerException e1) {
            logger.error((Object)"", (Throwable)e1);
        }
        return listObjectName;
    }

    private void append(StringBuffer objectName, String name, String value) {
        if (value != null && value.length() > 0) {
            if (objectName.length() > 0) {
                objectName.append(",");
            }
            objectName.append(name).append("=").append(value);
        }
    }
}

