/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.jca;

import javax.jms.MessageListener;
import org.jboss.soa.esb.Configurable;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.gateway.PackageJmsMessageContents;
import org.jboss.soa.esb.listeners.jca.InflowGateway;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;

public class JmsEndpoint
implements InflowGateway,
MessageListener,
Configurable {
    private ServiceInvoker service;
    private PackageJmsMessageContents transformer;

    @Override
    public void setConfiguration(ConfigTree config) throws ConfigurationException {
        MessagePayloadProxy proxy = PackageJmsMessageContents.createPayloadProxy(config);
        this.transformer = new PackageJmsMessageContents(proxy);
    }

    @Override
    public void setServiceInvoker(ServiceInvoker invoker) {
        this.service = invoker;
    }

    public void onMessage(javax.jms.Message message) {
        if (this.transformer == null) {
            throw new IllegalStateException("Class not configured.  setConfiguration(ConfigTree) must be called before endpoint can listen for messages.");
        }
        try {
            Message esbMessage = this.transformer.process(message);
            this.service.deliverAsync(esbMessage);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

