/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.jca;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.couriers.FaultMessageException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerUtil;
import org.jboss.soa.esb.listeners.RegistryUtil;
import org.jboss.soa.esb.listeners.jca.BaseJcaInflow;
import org.jboss.soa.esb.listeners.jca.InflowMessageProcessor;
import org.jboss.soa.esb.listeners.jca.InflowMessageProcessorAdapter;
import org.jboss.soa.esb.listeners.jca.JcaGatewayException;
import org.jboss.soa.esb.listeners.jca.JcaMessageAwareComposer;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.listeners.message.ActionProcessingPipeline;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.util.ClassUtil;
import org.jboss.soa.esb.util.Util;

public class JcaMessageAwareListener
extends BaseJcaInflow<InflowMessageProcessorAdapter>
implements InflowMessageProcessor {
    private final String serviceCategory;
    private final String serviceName;
    private final EPR serviceEPR;
    private final JcaMessageAwareComposer composer;
    private ActionProcessingPipeline pipeline;

    public JcaMessageAwareListener(ConfigTree config) throws ConfigurationException {
        super(config, InflowMessageProcessorAdapter.class);
        Class composerClass;
        this.serviceCategory = ListenerUtil.getValue(config, "service-category");
        if (Util.isNullString(this.serviceCategory)) {
            throw new ConfigurationException("No service category defined!");
        }
        this.serviceName = ListenerUtil.getValue(config, "service-name");
        if (Util.isNullString(this.serviceName)) {
            throw new ConfigurationException("No service name defined!");
        }
        ConfigTree eprElement = config.getFirstChild("EPR");
        if (eprElement == null) {
            throw new ConfigurationException("Missing EPR element");
        }
        this.serviceEPR = ListenerUtil.assembleEpr(eprElement);
        String composerName = config.getAttribute("listener-composer");
        if (Util.isNullString(composerName)) {
            throw new ConfigurationException("No composer class defined");
        }
        try {
            composerClass = ClassUtil.forName(composerName, this.getClass());
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConfigurationException("Could not load listener composer class", cnfe);
        }
        if (!JcaMessageAwareComposer.class.isAssignableFrom(composerClass)) {
            throw new ConfigurationException("Listener composer class does not implement JcaMessageAwareComposer interface");
        }
        try {
            this.composer = (JcaMessageAwareComposer)composerClass.newInstance();
        }
        catch (Throwable th) {
            throw new ConfigurationException("Unexpected exception caught while creating composer class", th);
        }
    }

    @Override
    protected String getDescription() {
        return "category: " + this.serviceCategory + " service: " + this.serviceName;
    }

    @Override
    protected void doInitialise() throws ManagedLifecycleException {
        super.doInitialise();
        ((InflowMessageProcessorAdapter)this.bean).setInflowMessageProcessor(this);
        try {
            this.pipeline = new ActionProcessingPipeline(this.getConfig());
            this.pipeline.initialise();
        }
        catch (ConfigurationException ce) {
            throw new ManagedLifecycleException("Unexpected exception configuring action processing pipeline", ce);
        }
        this.pipeline.setTransactional(this.isTransactional());
        try {
            RegistryUtil.register(this.getConfig(), this.serviceEPR);
        }
        catch (RegistryException re) {
            throw new ManagedLifecycleException("Unexpected exception while registering service", re);
        }
    }

    @Override
    protected void doDestroy() throws ManagedLifecycleException {
        super.doDestroy();
        try {
            this.pipeline.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.pipeline = null;
        RegistryUtil.unregister(this.serviceCategory, this.serviceName, this.serviceEPR);
    }

    @Override
    public void process(Object messageIn) {
        try {
            try {
                Message message = this.composer.compose(messageIn);
                if (message != null) {
                    this.pipeline.process(message);
                }
            }
            catch (FaultMessageException fme) {
                this.pipeline.process(fme.getReturnedMessage());
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Error err) {
            throw err;
        }
        catch (Throwable th) {
            throw new JcaGatewayException("Unexpected exception caught while processing JCA message", th);
        }
    }
}

