/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.jca;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.listeners.jca.EndpointContainer;
import org.jboss.tm.TransactionManagerLocator;

public class EndpointProxy
implements InvocationHandler {
    private static final Logger log = Logger.getLogger(EndpointProxy.class);
    private boolean trace = log.isTraceEnabled();
    protected SynchronizedBoolean released = new SynchronizedBoolean(false);
    protected boolean delivered = false;
    protected Thread inUseThread = null;
    protected ClassLoader oldClassLoader = null;
    protected boolean beforeDeliveryInvoked;
    protected Transaction transaction = null;
    protected Transaction suspended = null;
    protected ClassLoader loader;
    private XAResource resource;
    private MessageEndpointFactory messageEndpointFactory;
    private EndpointContainer container;

    public void setContainer(EndpointContainer container) {
        this.container = container;
    }

    public void setMessageEndpointFactory(MessageEndpointFactory messageEndpointFactory) {
        this.messageEndpointFactory = messageEndpointFactory;
    }

    public void setXaResource(XAResource resource) {
        this.resource = resource;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.released.get()) {
            throw new IllegalStateException("This message endpoint + " + this.getProxyString(proxy) + " has been released");
        }
        Thread currentThread = Thread.currentThread();
        if (this.inUseThread != null && !this.inUseThread.equals(currentThread)) {
            throw new IllegalStateException("This message endpoint + " + this.getProxyString(proxy) + " is already in use by another thread " + this.inUseThread);
        }
        this.inUseThread = currentThread;
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(proxy) + " in use by " + method + " " + this.inUseThread));
        }
        if (method.getName().equals("release")) {
            this.release(proxy);
            return null;
        }
        if (method.getName().equals("beforeDelivery")) {
            this.before(proxy, method, args);
            return null;
        }
        if (method.getName().equals("afterDelivery")) {
            this.after(proxy);
            return null;
        }
        return this.delivery(proxy, method, args);
    }

    protected void release(Object proxy) throws Throwable {
        this.released.set(true);
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(proxy) + " released"));
        }
        if (this.beforeDeliveryInvoked) {
            try {
                this.finish("release", proxy, false);
            }
            catch (Throwable t) {
                log.warn((Object)"Error in release ", t);
            }
        }
    }

    protected void before(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.beforeDeliveryInvoked) {
            throw new IllegalStateException("Missing afterDelivery from the previous beforeDelivery for message endpoint " + this.getProxyString(proxy));
        }
        this.beforeDeliveryInvoked = true;
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(proxy) + " released"));
        }
        this.oldClassLoader = this.inUseThread.getContextClassLoader();
        this.inUseThread.setContextClassLoader(this.loader);
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(proxy) + " set context classloader to " + this.loader));
        }
        try {
            Method beforeMethod = (Method)args[0];
            boolean isTransacted = this.messageEndpointFactory.isDeliveryTransacted(beforeMethod);
            this.startTransaction("beforeDelivery", proxy, method, args, isTransacted);
        }
        catch (Throwable t) {
            this.resetContextClassLoader(proxy);
            throw new ResourceException(t);
        }
    }

    protected void after(Object proxy) throws Throwable {
        if (!this.beforeDeliveryInvoked) {
            throw new IllegalStateException("afterDelivery without a previous beforeDelivery for message endpoint " + this.getProxyString(proxy));
        }
        this.beforeDeliveryInvoked = false;
        try {
            this.finish("afterDelivery", proxy, true);
        }
        catch (Throwable t) {
            throw new ResourceException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object delivery(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.delivered) {
            throw new IllegalStateException("Multiple message delivery between before and after delivery is not allowed for message endpoint " + this.getProxyString(proxy));
        }
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(proxy) + " delivering"));
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        if (this.beforeDeliveryInvoked) {
            this.delivered = true;
        } else {
            currentThread.setContextClassLoader(this.loader);
        }
        boolean commit = true;
        try {
            if (!this.beforeDeliveryInvoked) {
                boolean isTransacted = this.messageEndpointFactory.isDeliveryTransacted(method);
                this.startTransaction("delivery", proxy, method, args, isTransacted);
            }
            Object isTransacted = this.container.invoke(method, args);
            return isTransacted;
        }
        catch (Throwable t) {
            if (this.trace) {
                log.trace((Object)("MessageEndpoint " + this.getProxyString(proxy) + " delivery error"), t);
            }
            if (t instanceof Error || t instanceof RuntimeException) {
                if (this.transaction != null) {
                    this.transaction.setRollbackOnly();
                }
                commit = false;
            }
            throw t;
        }
        finally {
            if (!this.beforeDeliveryInvoked) {
                currentThread.setContextClassLoader(contextClassLoader);
                try {
                    this.endTransaction(proxy, commit);
                }
                finally {
                    this.releaseThreadLock(proxy);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finish(String context, Object proxy, boolean commit) throws Throwable {
        try {
            this.endTransaction(proxy, commit);
        }
        finally {
            this.delivered = false;
            this.resetContextClassLoader(proxy);
            this.releaseThreadLock(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTransaction(String context, Object proxy, Method m, Object[] args, boolean isTransacted) throws Throwable {
        Method method = "delivery".equals(context) ? m : (Method)args[0];
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(proxy) + " " + context + " method=" + method + " xaResource=" + this.resource + " transacted=" + isTransacted));
        }
        TransactionManager tm = TransactionManagerLocator.getInstance().locate();
        this.suspended = tm.suspend();
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(proxy) + " " + context + " currentTx=" + this.suspended));
        }
        if (isTransacted) {
            if (this.suspended == null) {
                tm.begin();
                this.transaction = tm.getTransaction();
                if (this.trace) {
                    log.trace((Object)("MessageEndpoint " + this.getProxyString(proxy) + " started transaction=" + this.transaction));
                }
                if (this.resource != null) {
                    this.transaction.enlistResource(this.resource);
                    if (this.trace) {
                        log.trace((Object)("MessageEndpoint " + this.getProxyString(proxy) + " enlisted=" + this.resource));
                    }
                }
            } else {
                try {
                    tm.resume(this.suspended);
                }
                finally {
                    this.suspended = null;
                    if (this.trace) {
                        log.trace((Object)("MessageEndpoint " + this.getProxyString(proxy) + " transaction=" + this.suspended + " already active, IGNORED=" + this.resource));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void endTransaction(Object proxy, boolean commit) throws Throwable {
        TransactionManager tm = null;
        Transaction currentTx = null;
        try {
            if (this.transaction != null) {
                tm = TransactionManagerLocator.getInstance().locate();
                currentTx = tm.getTransaction();
                if (currentTx != null && !currentTx.equals(this.transaction)) {
                    log.warn((Object)("Current transaction " + currentTx + " is not the expected transaction."));
                    tm.suspend();
                    tm.resume(this.transaction);
                } else {
                    currentTx = null;
                }
                if (!commit || this.transaction.getStatus() == 1) {
                    if (this.trace) {
                        log.trace((Object)("MessageEndpoint " + this.getProxyString(proxy) + " rollback"));
                    }
                    tm.rollback();
                } else {
                    if (this.trace) {
                        log.trace((Object)("MessageEndpoint " + this.getProxyString(proxy) + " commit"));
                    }
                    tm.commit();
                }
            }
            if (this.suspended != null) {
                try {
                    tm = TransactionManagerLocator.getInstance().locate();
                    tm.resume(this.suspended);
                }
                finally {
                    this.suspended = null;
                }
            }
            if (currentTx == null) return;
        }
        catch (Throwable throwable) {
            if (currentTx == null) throw throwable;
            try {
                tm.resume(currentTx);
                throw throwable;
            }
            catch (Throwable t) {
                log.warn((Object)("MessageEndpoint " + this.getProxyString(proxy) + " failed to resume old transaction " + currentTx));
            }
            throw throwable;
        }
        try {
            tm.resume(currentTx);
            return;
        }
        catch (Throwable t) {
            log.warn((Object)("MessageEndpoint " + this.getProxyString(proxy) + " failed to resume old transaction " + currentTx));
        }
    }

    protected void resetContextClassLoader(Object proxy) {
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(proxy) + " reset classloader " + this.oldClassLoader));
        }
        this.inUseThread.setContextClassLoader(this.oldClassLoader);
        this.oldClassLoader = null;
    }

    protected void releaseThreadLock(Object proxy) {
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(proxy) + " no longer in use by " + this.inUseThread));
        }
        this.inUseThread = null;
    }

    protected String getProxyString(Object proxy) {
        return this.container.getDescription();
    }
}

