/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway.mina;

import java.net.InetSocketAddress;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.gateway.mina.MessageHandler;
import org.jboss.soa.esb.util.ClassUtil;

public class UdpGatewayConfig {
    public static final String HOST_ATTR = "host";
    public static final String PORT_ATTR = "port";
    public static final String HANDLER_CLASS_ATTR = "handlerClass";
    private final ConfigTree config;

    public UdpGatewayConfig(ConfigTree config) {
        AssertArgument.isNotNull(config, "config");
        this.config = config;
    }

    public int getPort() throws ConfigurationException {
        return UdpGatewayConfig.parsePort(this.config.getRequiredAttribute(PORT_ATTR));
    }

    public InetSocketAddress getSocketAddress() throws ConfigurationException {
        return new InetSocketAddress(this.config.getRequiredAttribute(HOST_ATTR), this.getPort());
    }

    public String getServiceCategory() throws ConfigurationException {
        return this.config.getRequiredAttribute("target-service-category");
    }

    public String getServiceName() throws ConfigurationException {
        return this.config.getRequiredAttribute("target-service-name");
    }

    public MessageHandler getHandler() throws ConfigurationException {
        String handlerClass = this.config.getRequiredAttribute(HANDLER_CLASS_ATTR);
        try {
            return (MessageHandler)ClassUtil.forName(handlerClass, this.getClass()).newInstance();
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Class '" + handlerClass + "' must implement '" + MessageHandler.class.getName() + "'.");
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Failed to create an instance of MessagHandler implementation '" + handlerClass + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Failed to create an instance of MessagHandler implementation '" + handlerClass + "'.", e);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Failed to create an instance of MessagHandler implementation '" + handlerClass + "'.", e);
        }
    }

    public static int parsePort(String portString) throws ConfigurationException {
        int parseInt;
        try {
            parseInt = Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("port must be a postive integer. It was '" + portString + "'");
        }
        if (parseInt <= 0) {
            throw new ConfigurationException("port must be a postive integer. It was '" + portString + "'");
        }
        return parseInt;
    }
}

