/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway.mina;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.TransportType;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.listeners.gateway.mina.MessageHandler;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;

public class DefaultMessageHandler
extends IoHandlerAdapter
implements MessageHandler {
    private ServiceInvoker invoker;

    @Override
    public final void setServiceInvoker(ServiceInvoker invoker) {
        this.invoker = invoker;
    }

    public void sessionCreated(IoSession session) {
        if (session.getTransportType() == TransportType.SOCKET) {
            ((SocketSessionConfig)session.getConfig()).setReceiveBufferSize(2048);
        }
        session.setIdleTime(IdleStatus.BOTH_IDLE, 10);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        session.close();
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        if (!(message instanceof ByteBuffer)) {
            return;
        }
        ByteBuffer byteBuffer = (ByteBuffer)message;
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        Message esbMessage = MessageFactory.getInstance().getMessage();
        esbMessage.getBody().add(bytes);
        this.invoker.deliverAsync(esbMessage);
    }
}

