/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.http.HttpContentTypeUtil;
import org.jboss.soa.esb.http.HttpHeader;
import org.jboss.soa.esb.http.HttpRequest;
import org.jboss.soa.esb.http.HttpResponse;
import org.jboss.soa.esb.listeners.gateway.http.HttpRequestWrapper;
import org.jboss.soa.esb.listeners.message.AbstractMessageComposer;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.services.security.PublicCryptoUtil;
import org.jboss.soa.esb.services.security.auth.ExtractionException;
import org.jboss.soa.esb.services.security.auth.ExtractorUtil;
import org.jboss.soa.esb.services.security.auth.SecurityInfoExtractor;
import org.jboss.soa.esb.services.security.auth.ws.BinarySecurityTokenExtractor;
import org.jboss.soa.esb.services.security.auth.ws.UsernameTokenExtractor;

public class HttpMessageComposer<T extends HttpRequestWrapper>
extends AbstractMessageComposer<T> {
    private static final Logger logger = Logger.getLogger(HttpMessageComposer.class);
    private MessagePayloadProxy payloadProxy;
    private String payloadAs;
    private final Set<SecurityInfoExtractor<String>> extractors = new LinkedHashSet<SecurityInfoExtractor<String>>();
    private static Set<String> responseHeaderFilterset = new HashSet<String>();
    private static final Map<String, String> localAddr_to_localName;

    private static final String getLocalName(HttpServletRequest request) {
        String localAddr = request.getLocalAddr();
        String localName = localAddr_to_localName.get(localAddr);
        if (localName == null) {
            localName = request.getLocalName();
            localAddr_to_localName.put(localAddr, localName);
        }
        return localName;
    }

    @Override
    public void setConfiguration(ConfigTree config) {
        super.setConfiguration(config);
        this.payloadProxy = new MessagePayloadProxy(config);
        this.payloadProxy.setNullSetPayloadHandling(MessagePayloadProxy.NullPayloadHandling.LOG);
        this.payloadAs = config.getAttribute("payloadAs");
        String securityNS = config.getAttribute("securityNS", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        this.extractors.add(new UsernameTokenExtractor(securityNS));
        this.extractors.add(new BinarySecurityTokenExtractor(securityNS));
    }

    @Override
    protected MessagePayloadProxy getPayloadProxy() {
        return this.payloadProxy;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void populateMessage(Message message, T requestWrapper) throws MessageDeliverException {
        request = requestWrapper.getRequest();
        bodyBytes = null;
        try {
            bodyBytes = StreamUtils.readStream((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            throw new MessageDeliverException("Failed to read body data from http request", e);
        }
        characterEncoding = request.getCharacterEncoding();
        charset = characterEncoding == null ? Charset.defaultCharset() : Charset.forName(characterEncoding);
        if (this.payloadAs == null) {
            contentType = request.getContentType();
            if (contentType != null && HttpContentTypeUtil.isTextMimetype(contentType)) {
                try {
                    payload = new String(bodyBytes, charset.name());
                    this.payloadProxy.setPayload(message, payload);
                    authRequest = null;
                    try {
                        authRequest = ExtractorUtil.extract(payload, this.extractors);
                    }
                    catch (ExtractionException e) {
                        throw new MessageDeliverException(e.getMessage(), e);
                    }
                    if (authRequest == null) ** GOTO lbl37
                    PublicCryptoUtil.INSTANCE.addAuthRequestToMessage(authRequest, message);
                }
                catch (UnsupportedEncodingException e) {
                    throw new MessageDeliverException("Invalid Character encoding '" + characterEncoding + "' set on request.", e);
                }
            } else {
                this.payloadProxy.setPayload(message, bodyBytes);
            }
        } else if (this.payloadAs.equals("STRING")) {
            try {
                this.payloadProxy.setPayload(message, new String(bodyBytes, charset.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new MessageDeliverException("Invalid Character encoding '" + characterEncoding + "' set on request.", e);
            }
        } else {
            this.payloadProxy.setPayload(message, bodyBytes);
        }
lbl37:
        // 5 sources

        requestInfo = this.getRequestInfo(request);
        requestInfo.setRequest(message);
    }

    @Override
    public Object decompose(Message message, T requestWrapper) throws MessageDeliverException {
        HttpServletRequest request = ((HttpRequestWrapper)requestWrapper).getRequest();
        HttpServletResponse response = ((HttpRequestWrapper)requestWrapper).getResponse();
        Integer status = 200;
        String encoding = null;
        HttpResponse responseInfo = HttpResponse.getResponse(message);
        if (responseInfo != null) {
            for (HttpHeader header : responseInfo.getHttpHeaders()) {
                String headerName = header.getName().toLowerCase();
                if (headerName.equals("content-type")) {
                    response.setContentType(header.getValue());
                    continue;
                }
                if (responseHeaderFilterset.contains(headerName)) continue;
                response.setHeader(header.getName(), header.getValue());
            }
            if (responseInfo.getContentType() != null) {
                response.setContentType(responseInfo.getContentType());
            }
            encoding = responseInfo.getEncoding();
            status = responseInfo.getResponseCode();
        }
        if (encoding == null && (encoding = request.getCharacterEncoding()) == null) {
            encoding = "UTF-8";
        }
        Object obj = this.payloadProxy.getPayload(message);
        try {
            byte[] outBytes;
            if (obj instanceof String) {
                outBytes = ((String)obj).getBytes(encoding);
            } else if (obj instanceof byte[]) {
                outBytes = (byte[])obj;
            } else {
                if (obj == null) {
                    response.setContentLength(0);
                    response.setStatus(204);
                    logger.debug((Object)("Expected a response payload from 'RequestResponse' service '" + ((HttpRequestWrapper)requestWrapper).getService() + "', but received none."));
                    return null;
                }
                response.setContentLength(0);
                response.setStatus(502);
                logger.debug((Object)("Unsupport HTTP response payload type " + obj.getClass().getName() + " from service '" + ((HttpRequestWrapper)requestWrapper).getService() + "'.  Only supports java.lang.String or byte[] payloads."));
                return null;
            }
            response.setCharacterEncoding(encoding);
            response.setContentLength(outBytes.length);
            response.setStatus(status.intValue());
            if (outBytes.length > 0) {
                response.getOutputStream().write(outBytes);
            }
        }
        catch (IOException e) {
            throw new MessageDeliverException("Unexpected error when write the message to http response", e);
        }
        return null;
    }

    public HttpRequest getRequestInfo(HttpServletRequest request) {
        Map paramMap;
        HttpRequest requestInfo = new HttpRequest();
        requestInfo.setAuthType(request.getAuthType());
        requestInfo.setCharacterEncoding(request.getCharacterEncoding());
        requestInfo.setContentType(request.getContentType());
        requestInfo.setContextPath(request.getContextPath());
        requestInfo.setLocalAddr(request.getLocalAddr());
        requestInfo.setLocalName(HttpMessageComposer.getLocalName(request));
        requestInfo.setMethod(request.getMethod());
        requestInfo.setProtocol(request.getProtocol());
        requestInfo.setQueryString(request.getQueryString());
        requestInfo.setRemoteAddr(request.getRemoteAddr());
        requestInfo.setRemoteHost(request.getRemoteHost());
        requestInfo.setRemoteUser(request.getRemoteUser());
        requestInfo.setContentLength(request.getContentLength());
        requestInfo.setRequestSessionId(request.getRequestedSessionId());
        requestInfo.setRequestURI(request.getRequestURI());
        requestInfo.setScheme(request.getScheme());
        requestInfo.setServerName(request.getServerName());
        requestInfo.setRequestPath(request.getServletPath());
        String pathInfo = request.getPathInfo();
        requestInfo.setPathInfo(pathInfo);
        if (pathInfo != null) {
            List<String> pathInfoTokens = requestInfo.getPathInfoTokens();
            pathInfoTokens.addAll(Arrays.asList(request.getPathInfo().split("/")));
            Iterator<String> tokensIterator = pathInfoTokens.iterator();
            while (tokensIterator.hasNext()) {
                if (tokensIterator.next().trim().length() != 0) continue;
                tokensIterator.remove();
            }
        }
        if ((paramMap = request.getParameterMap()) != null) {
            requestInfo.getQueryParams().putAll(paramMap);
        }
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = request.getHeader(name);
            requestInfo.getHeaders().add(new HttpHeader(name, value));
        }
        return requestInfo;
    }

    static {
        responseHeaderFilterset.add("transfer-encoding");
        responseHeaderFilterset.add("content-length");
        responseHeaderFilterset.add("server");
        localAddr_to_localName = new ConcurrentHashMap<String, String>();
    }
}

