/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.io.File;
import java.io.IOException;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerUtil;
import org.jboss.soa.esb.listeners.gateway.AbstractFileGateway;
import org.jboss.soa.esb.listeners.message.MessageComposer;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.util.FileUtil;
import org.jboss.soa.esb.util.FtpClientUtil;
import org.jboss.soa.esb.util.RemoteFileSystem;
import org.jboss.soa.esb.util.RemoteFileSystemException;
import org.jboss.soa.esb.util.RemoteFileSystemFactory;

public class RemoteFileMessageComposer<T extends File>
implements MessageComposer<T> {
    private FTPEpr ftpEpr;
    private File downloadDir;
    private MessagePayloadProxy payloadProxy;

    @Override
    public void setConfiguration(ConfigTree config) throws ConfigurationException {
        EPR epr = ListenerUtil.assembleEpr(config);
        if (!(epr instanceof FTPEpr)) {
            throw new ConfigurationException("This Gateway only accepts FTP and SFTP.");
        }
        this.ftpEpr = (FTPEpr)epr;
        this.downloadDir = AbstractFileGateway.getFileInputDirectory(config);
        this.payloadProxy = new MessagePayloadProxy(config, new String[]{"org.jboss.soa.esb.message.content.bytes"}, new String[]{"org.jboss.soa.esb.message.content.bytes"});
    }

    @Override
    public Message compose(T inputFile) throws MessageDeliverException {
        AssertArgument.isNotNull(inputFile, "inputFile");
        Message message = MessageFactory.getInstance().getMessage();
        try {
            this.payloadProxy.setPayload(message, this.getPayload(inputFile));
        }
        catch (IOException e) {
            throw new MessageDeliverException("Error reading remote input file '" + ((File)inputFile).getAbsolutePath() + "'.", e);
        }
        catch (RemoteFileSystemException e) {
            throw new MessageDeliverException("Error reading remote input file '" + ((File)inputFile).getAbsolutePath() + "'.", e);
        }
        return message;
    }

    protected Object getPayload(T inputFile) throws RemoteFileSystemException, IOException {
        return this.getFileContents((File)inputFile);
    }

    @Override
    public Object decompose(Message message, T inputMessage) throws MessageDeliverException {
        return this.payloadProxy.getPayload(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getFileContents(File file) throws IOException, RemoteFileSystemException {
        RemoteFileSystem remoteFileSystem = null;
        File temp = File.createTempFile("FTPdown", ".tmp");
        try {
            remoteFileSystem = RemoteFileSystemFactory.getRemoteFileSystem(this.ftpEpr, true);
            remoteFileSystem.setRemoteDir(FtpClientUtil.fileToFtpString(this.downloadDir));
            remoteFileSystem.downloadFile(file.toString(), temp.getAbsolutePath());
            byte[] byArray = FileUtil.readFile(temp);
            return byArray;
        }
        finally {
            temp.delete();
            if (null != remoteFileSystem) {
                remoteFileSystem.quit();
            }
        }
    }
}

