/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.io.File;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.gateway.GatewayException;
import org.jboss.soa.esb.listeners.gateway.RemoteGatewayListener;
import org.jboss.soa.esb.listeners.gateway.remotestrategies.ReadOnlyRemoteFileSystemStrategy;
import org.jboss.soa.esb.listeners.gateway.remotestrategies.RemoteFileSystemStrategy;
import org.jboss.soa.esb.listeners.gateway.remotestrategies.RemoteFileSystemStrategyException;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.util.ClassUtil;

public class ReadOnlyRemoteGatewayListener
extends RemoteGatewayListener {
    public static final String REMOTE_FILE_SYSTEM_STRATEGY_CLASS = "remoteFileSystemStrategy-class";
    public static final String REMOTE_FILE_SYSTEM_STRATEGY_CONFIG_FILE = "remoteFileSystemStrategy-configFile";
    public static final String REMOTE_FILE_SYSTEM_STRATEGY_CACHE_LISTENER = "remoteFileSystemStrategy-cacheListener";
    private RemoteFileSystemStrategy remotefileSystemStrategy;

    public ReadOnlyRemoteGatewayListener(ConfigTree config) throws ConfigurationException, RegistryException, GatewayException {
        super(config);
        this.createRemoteFileSystemStrategy();
    }

    @Override
    public boolean deleteFile(File file) throws GatewayException {
        try {
            return this.remotefileSystemStrategy.deleteFile(file);
        }
        catch (RemoteFileSystemStrategyException e) {
            throw new GatewayException(e);
        }
    }

    @Override
    File[] getFileList() throws GatewayException {
        try {
            return this.remotefileSystemStrategy.filterFileList(super.getFileList());
        }
        catch (RemoteFileSystemStrategyException e) {
            throw new GatewayException(e);
        }
    }

    @Override
    boolean renameFile(File from, File to) throws GatewayException {
        try {
            return this.remotefileSystemStrategy.renameFile(from, to);
        }
        catch (RemoteFileSystemStrategyException e) {
            throw new GatewayException(e);
        }
    }

    @Override
    protected File getWorkFileName(File file, String suffix) {
        return this.remotefileSystemStrategy.getWorkFileName(file, suffix);
    }

    public void setRemotefileSystemStrategy(RemoteFileSystemStrategy remotefileSystemStrategy) {
        this.remotefileSystemStrategy = remotefileSystemStrategy;
    }

    protected <T> T getNewInstanceOf(String className) throws ConfigurationException {
        if (className == null) {
            throw new IllegalArgumentException("className argument must not be null.");
        }
        T instance = null;
        try {
            Class type = ClassUtil.forName(className, this.getClass());
            instance = type.newInstance();
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            throw new ConfigurationException(ex);
        }
        return instance;
    }

    @Override
    protected void doStop() throws ManagedLifecycleException {
        super.doStop();
        this.remotefileSystemStrategy.stop();
    }

    @Override
    protected void doScheduledDestroy() throws ManagedLifecycleException {
        super.doScheduledDestroy();
        this.remotefileSystemStrategy.destroy();
    }

    private void createRemoteFileSystemStrategy() throws ConfigurationException {
        String strategyClassName = this.config.getAttribute(REMOTE_FILE_SYSTEM_STRATEGY_CLASS);
        RemoteFileSystemStrategy strategy = null;
        if (strategyClassName != null) {
            strategy = (RemoteFileSystemStrategy)this.getNewInstanceOf(strategyClassName);
        }
        this.remotefileSystemStrategy = strategy != null ? strategy : new ReadOnlyRemoteFileSystemStrategy();
        String configFile = this.config.getAttribute(REMOTE_FILE_SYSTEM_STRATEGY_CONFIG_FILE);
        try {
            this.remotefileSystemStrategy.init(configFile);
            if (this.remotefileSystemStrategy instanceof ReadOnlyRemoteFileSystemStrategy) {
                ReadOnlyRemoteFileSystemStrategy rm = (ReadOnlyRemoteFileSystemStrategy)this.remotefileSystemStrategy;
                String cacheListener = this.config.getAttribute(REMOTE_FILE_SYSTEM_STRATEGY_CACHE_LISTENER);
                if (cacheListener != null) {
                    Class cacheListenerClass = ClassUtil.forName(cacheListener, this.getClass());
                    rm.setCacheListener(cacheListenerClass);
                }
            }
        }
        catch (RemoteFileSystemStrategyException e) {
            _logger.error((Object)"Could not configure the remoteFileSystemStrategy.", (Throwable)e);
            throw new ConfigurationException(e);
        }
        catch (ClassNotFoundException e) {
            _logger.error((Object)"ClassNotFound while trying to create the the remoteFileSystemStrategy.", (Throwable)e);
            throw new ConfigurationException(e);
        }
    }
}

