/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.io.File;
import java.io.IOException;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageComposer;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.util.FileUtil;

public class LocalFileMessageComposer<T extends File>
implements MessageComposer<T> {
    public static final String PROP_FILE_OBJ = "in-file-obj";
    public static final String PROP_FILE_PATH = "in-file-path";
    public static final String PROP_FILE_LENGTH = "in-file-length";
    public static final String PROP_FILE_LASTMOD = "in-file-lastmod";
    private MessagePayloadProxy payloadProxy;

    @Override
    public void setConfiguration(ConfigTree config) throws ConfigurationException {
        this.payloadProxy = new MessagePayloadProxy(config, new String[]{"org.jboss.soa.esb.message.content.bytes"}, new String[]{"org.jboss.soa.esb.message.content.bytes"});
    }

    @Override
    public Message compose(T inputFile) throws MessageDeliverException {
        AssertArgument.isNotNull(inputFile, "inputFile");
        if (!((File)inputFile).exists()) {
            throw new MessageDeliverException("Invalid File payload.  File '" + ((File)inputFile).getAbsolutePath() + "' doesn't exist.");
        }
        Message message = MessageFactory.getInstance().getMessage();
        try {
            this.payloadProxy.setPayload(message, this.getPayload(inputFile));
        }
        catch (IOException e) {
            throw new MessageDeliverException("Error reading input file '" + ((File)inputFile).getAbsolutePath() + "'.", e);
        }
        message.getProperties().setProperty(PROP_FILE_OBJ, inputFile);
        message.getProperties().setProperty(PROP_FILE_PATH, ((File)inputFile).getAbsolutePath());
        message.getProperties().setProperty(PROP_FILE_LENGTH, ((File)inputFile).length());
        message.getProperties().setProperty(PROP_FILE_LASTMOD, ((File)inputFile).lastModified());
        return message;
    }

    protected Object getPayload(T inputFile) throws IOException {
        return FileUtil.readFile(inputFile);
    }

    @Override
    public Object decompose(Message message, T inputFile) throws MessageDeliverException {
        return this.payloadProxy.getPayload(message);
    }
}

