/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.persist.HibernateSessionFactory;
import org.jboss.soa.esb.listeners.ListenerUtil;
import org.jboss.soa.esb.listeners.gateway.HibernateEventBean;
import org.jboss.soa.esb.listeners.gateway.HibernateInterceptor;
import org.jboss.soa.esb.listeners.lifecycle.AbstractManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;

public class HibernateGatewayListener
extends AbstractManagedLifecycle {
    private String m_cfgFile;
    private ConfigTree m_config;
    protected Object _composer;
    protected Class _composerClass;
    protected String _composerName;
    protected String m_targetServiceCategory;
    protected String m_targetServiceName;
    private HibernateInterceptor interceptor;
    protected Collection<EPR> m_targetEprs;
    private static final String MESSAGE_FILTER = "messagefilter";
    protected static final Logger m_logger = Logger.getLogger(HibernateGatewayListener.class);

    public HibernateGatewayListener(ConfigTree config) throws ConfigurationException {
        super(config);
        this.m_config = config;
        this.m_cfgFile = ListenerUtil.getValue(this.m_config, "hibernate-cfg-file", null);
        if (this.m_cfgFile == null) {
            throw new ConfigurationException("No configuration file specified!");
        }
    }

    @Override
    protected void doDestroy() throws ManagedLifecycleException {
        Configuration cfg = new Configuration();
        cfg.configure(this.m_cfgFile);
        HibernateSessionFactory.close(cfg);
    }

    @Override
    protected void doInitialise() throws ManagedLifecycleException {
        ArrayList<HibernateEventBean> eventList = new ArrayList<HibernateEventBean>();
        Configuration cfg = new Configuration();
        cfg.configure(this.m_cfgFile);
        for (ConfigTree ct : this.m_config.getChildren(MESSAGE_FILTER)) {
            try {
                String tempEvent = ListenerUtil.getValue(ct, "event", null);
                if (tempEvent == null) {
                    throw new ConfigurationException("No event specified.");
                }
                String[] events = tempEvent.split(",");
                for (int i = 0; i < events.length; ++i) {
                    HibernateEventBean heb = new HibernateEventBean();
                    heb.setEvent(events[i]);
                    heb.setClassname(ListenerUtil.getValue(ct, "classname", null));
                    if (heb.getClassname() == null) {
                        throw new ConfigurationException("No classname specified.");
                    }
                    eventList.add(heb);
                }
            }
            catch (ConfigurationException ce) {
                m_logger.error((Object)"Problem parsing Message Filter event/classname");
            }
        }
        try {
            if (eventList.size() != 0) {
                this.interceptor = new HibernateInterceptor(this.m_config, eventList);
                cfg.setInterceptor((Interceptor)this.interceptor);
            }
            SessionFactory sf = null;
            HibernateSessionFactory.close(cfg);
            sf = HibernateSessionFactory.getInstance(cfg);
        }
        catch (ConfigurationException ce) {
            throw new ManagedLifecycleException(ce.getMessage());
        }
    }

    @Override
    protected void doStart() throws ManagedLifecycleException {
        if (this.interceptor != null) {
            this.interceptor.enable();
        }
    }

    @Override
    protected void doStop() throws ManagedLifecycleException {
        if (this.interceptor != null) {
            this.interceptor.disable();
        }
    }
}

