/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.listeners.gateway.ESBPropertiesSetter;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.Properties;

public class DefaultESBPropertiesSetter
implements ESBPropertiesSetter {
    private Logger log = Logger.getLogger(DefaultESBPropertiesSetter.class);
    private Pattern propertiesPattern;

    public DefaultESBPropertiesSetter() {
    }

    public DefaultESBPropertiesSetter(String propertiesFilter) {
        AssertArgument.isNotNull(propertiesFilter, "propertiesFilter");
        this.propertiesPattern = Pattern.compile(propertiesFilter);
    }

    @Override
    public void setPropertiesFromJMSMessage(javax.jms.Message fromJMSMessage, Message toESBMessage) throws JMSException {
        this.setCorrelationID(fromJMSMessage, toESBMessage);
        this.setReplyTo(fromJMSMessage, toESBMessage);
        this.setExpiration(fromJMSMessage, toESBMessage);
        this.setRedelivered(fromJMSMessage, toESBMessage);
        this.setProperties(fromJMSMessage, toESBMessage);
    }

    private void setCorrelationID(javax.jms.Message fromJMSMessage, Message toESBMessage) throws JMSException {
        if (fromJMSMessage.getJMSCorrelationID() != null) {
            try {
                URI correlationURI = new URI("jms", "correlationID", fromJMSMessage.getJMSCorrelationID());
                toESBMessage.getHeader().getCall().setRelatesTo(correlationURI);
            }
            catch (URISyntaxException e) {
                String errorMessage = "Could not set ESB setRelatesTo to JMSCorrelationID [ " + fromJMSMessage.getJMSCorrelationID() + "]";
                throw new JMSException(errorMessage);
            }
        }
    }

    private void setReplyTo(javax.jms.Message fromJMSMessage, Message esbMessage) throws JMSException {
        Destination destination = fromJMSMessage.getJMSReplyTo();
        if (destination != null) {
            esbMessage.getProperties().setProperty("javax.jms.message.replyTo", destination);
        }
    }

    private void setExpiration(javax.jms.Message fromJMSMessage, Message toESBMessage) throws JMSException {
        if (fromJMSMessage.getJMSExpiration() != 0L) {
            long ttl = fromJMSMessage.getJMSExpiration() - System.currentTimeMillis();
            if (ttl < 0L) {
                ttl = 0L;
            }
            this.log.debug((Object)("Setting JMS Expiration : " + ttl));
            toESBMessage.getProperties().setProperty("javax.jms.message.expiration", ttl);
        }
    }

    private void setRedelivered(javax.jms.Message fromJMSMessage, Message toESBMessage) throws JMSException {
        boolean redelivered = fromJMSMessage.getJMSRedelivered();
        toESBMessage.getProperties().setProperty("javax.jms.message.redelivered", redelivered);
    }

    private void setProperties(javax.jms.Message fromJMSMessage, Message toESBMessage) throws JMSException {
        Enumeration properties = fromJMSMessage.getPropertyNames();
        Properties esbProperties = toESBMessage.getProperties();
        if (null != properties) {
            while (properties.hasMoreElements()) {
                Object value;
                String key = (String)properties.nextElement();
                if (this.filter() && this.propertiesPattern.matcher(key).matches() || null == (value = fromJMSMessage.getObjectProperty(key))) continue;
                esbProperties.setProperty(key, value);
            }
        }
    }

    private boolean filter() {
        return this.propertiesPattern != null;
    }
}

