/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.message.LegacyMessageComposerAdapter;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.filter.FilterManager;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerUtil;
import org.jboss.soa.esb.listeners.gateway.GatewayException;
import org.jboss.soa.esb.listeners.lifecycle.AbstractScheduledManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleState;
import org.jboss.soa.esb.listeners.message.MessageComposer;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.schedule.SchedulingException;
import org.jboss.soa.esb.services.registry.RegistryException;

public abstract class AbstractFileGateway
extends AbstractScheduledManagedLifecycle {
    protected static final Logger _logger = Logger.getLogger(AbstractFileGateway.class);
    protected ConfigTree config;
    protected long _maxMillisForResponse;
    protected Service targetService;
    protected ServiceInvoker serviceInvoker;
    protected MessageComposer messageComposer;
    protected boolean _deleteAfterOK;
    protected boolean _renameAfterOK;
    protected File _inputDirectory;
    protected File _errorDirectory;
    protected File _postProcessDirectory;
    protected String _inputSuffix;
    protected String _postProcessSuffix;
    protected String _workingSuffix;
    protected String _errorSuffix;

    protected AbstractFileGateway(ConfigTree config) throws ConfigurationException, RegistryException, GatewayException {
        super(config);
        this.config = config;
        this.checkMyParms();
    }

    @Override
    protected void doInitialise() throws ManagedLifecycleException {
        try {
            this.serviceInvoker = new ServiceInvoker(this.targetService);
        }
        catch (MessageDeliverException e) {
            throw new ManagedLifecycleException(e);
        }
    }

    @Override
    public void onSchedule() throws SchedulingException {
        File[] fileList;
        try {
            fileList = this.getFileList();
            if (fileList == null) {
                _logger.warn((Object)"No files to process.");
                return;
            }
        }
        catch (GatewayException e) {
            _logger.error((Object)"Can't retrieve file list", (Throwable)e);
            return;
        }
        for (File fileIn : fileList) {
            File workingFile;
            block15: {
                if (this.getState() != ManagedLifecycleState.STARTED) break;
                workingFile = this.setFileWorking(fileIn);
                if (workingFile == null) continue;
                try {
                    Message message;
                    try {
                        message = this.messageComposer.compose(workingFile);
                    }
                    catch (MessageDeliverException e) {
                        this.processException("Composer <" + this.messageComposer.getClass().getName() + "> Failed.", e, fileIn, workingFile);
                        continue;
                    }
                    if (message == null) {
                        _logger.warn((Object)("Composer <" + this.messageComposer.getClass().getName() + "> returned a null object"));
                        continue;
                    }
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("org.jboss.soa.esb.gateway.file", fileIn);
                    params.put("org.jboss.soa.esb.gateway.config", this.config);
                    message = FilterManager.getInstance().doOutputWork(message, params);
                    try {
                        if (this._maxMillisForResponse > 0L) {
                            Message replyMsg = this.serviceInvoker.deliverSync(message, this._maxMillisForResponse);
                            replyMsg.getAttachment().put("org.jboss.soa.esb.gateway.file", fileIn);
                            try {
                                this.processReply(replyMsg, fileIn);
                                break block15;
                            }
                            catch (GatewayException e) {
                                this.processException("Failed to process reply.", e, fileIn, workingFile);
                                continue;
                            }
                        }
                        this.serviceInvoker.deliverAsync(message);
                        break block15;
                    }
                    catch (MessageDeliverException e) {
                        this.processException("Message Delivery Failure.", e, fileIn, workingFile);
                    }
                    catch (RegistryException e) {
                        this.processException("Message Delivery Failure.", e, fileIn, workingFile);
                    }
                }
                catch (CourierException e) {
                    this.processException("Message Delivery Failure.", e, fileIn, workingFile);
                }
                continue;
            }
            this.processingComplete(fileIn, workingFile);
        }
    }

    private void processingComplete(File fileIn, File workingFile) {
        File fileOK = new File(this._postProcessDirectory, fileIn.getName() + this._postProcessSuffix);
        if (this._deleteAfterOK) {
            try {
                this.deleteFile(workingFile);
            }
            catch (GatewayException e) {
                _logger.error((Object)("File " + fileIn + " has been processed and renamed to " + workingFile + ", but there were problems deleting it from the input directory "), (Throwable)e);
            }
        } else {
            try {
                if (this._renameAfterOK) {
                    this.renameFile(workingFile, fileOK);
                }
            }
            catch (GatewayException e) {
                _logger.error((Object)("File " + fileIn + " has been processed and renamed to " + workingFile + ", but there were problems renaming it to " + fileOK), (Throwable)e);
            }
        }
    }

    private void processException(String message, Throwable thrown, File fileIn, File workingFile) {
        _logger.error((Object)message, thrown);
        File fileError = new File(this._errorDirectory, fileIn.getName() + this._errorSuffix);
        try {
            this.deleteFile(fileError);
        }
        catch (GatewayException e) {
            _logger.warn((Object)("File : " + fileError + " did not exist."));
        }
        try {
            this.renameFile(workingFile, fileError);
        }
        catch (GatewayException e) {
            _logger.error((Object)("Problems renaming file " + workingFile + " to " + fileError), (Throwable)e);
        }
    }

    private void processReply(Message replyMsg, File fileIn) throws MessageDeliverException, GatewayException {
        Object responseData = this.messageComposer.decompose(replyMsg, fileIn);
        if (responseData != null) {
            if (responseData instanceof byte[]) {
                File responseFile = new File(fileIn.getParent(), fileIn.getName() + "_reply" + "_gw");
                this.bytesToFile((byte[])responseData, responseFile);
            } else {
                _logger.error((Object)"File based composers must return a byte[] from their decompose implementations.");
            }
        }
    }

    protected File setFileWorking(File file) {
        File workingFile = this.getWorkFileName(file, this._workingSuffix);
        try {
            if (this.renameFile(file, workingFile)) {
                return workingFile;
            }
        }
        catch (GatewayException e) {
            _logger.error((Object)("Unable to rename file '" + file.getAbsolutePath() + "' to it's working name '" + workingFile + "'. May be a contention issue with another listener.  You should avoid having multiple listeners polling on the same file subset.  Ignoring this file for now!"));
        }
        return null;
    }

    protected File getWorkFileName(File fileIn, String suffix) {
        return new File(fileIn.toString() + this._workingSuffix);
    }

    protected void checkInputSuffix() throws ConfigurationException {
        if (this._inputSuffix.length() < 1) {
            throw new ConfigurationException("Invalid inputSuffix attribute");
        }
    }

    private void checkMyParms() throws ConfigurationException {
        this.targetService = Service.getGatewayTargetService(this.config);
        String composerClass = this.config.getAttribute("composer-class");
        if (composerClass == null) {
            composerClass = this.getDefaultComposer();
        }
        this.messageComposer = MessageComposer.Factory.getInstance(composerClass, this.config, LegacyFileMessageComposerAdapter.class);
        this._maxMillisForResponse = ListenerUtil.getMaxMillisGatewayWait(this.config, _logger);
        String sInpDir = AbstractFileGateway.getInputDir(this.config);
        this._inputDirectory = AbstractFileGateway.fileFromString(sInpDir);
        this.seeIfOkToWorkOnDir(this._inputDirectory);
        this._inputSuffix = ListenerUtil.getValue(this.config, "inputSuffix", "").trim();
        this.checkInputSuffix();
        this._workingSuffix = ListenerUtil.getValue(this.config, "workSuffix", ".esbWork").trim();
        if (this._workingSuffix.length() < 1) {
            throw new ConfigurationException("Invalid workSuffix attribute");
        }
        if (this._inputSuffix.equals(this._workingSuffix)) {
            throw new ConfigurationException("Work suffix must differ from input suffix <" + this._workingSuffix + ">");
        }
        String sErrDir = ListenerUtil.getValue(this.config, "errorDir", sInpDir);
        this._errorDirectory = AbstractFileGateway.fileFromString(sErrDir);
        this.seeIfOkToWorkOnDir(this._errorDirectory);
        this._errorSuffix = ListenerUtil.getValue(this.config, "errorSuffix", ".esbError").trim();
        if (this._errorSuffix.length() < 1) {
            throw new ConfigurationException("Invalid errorSuffix attribute");
        }
        if (this._errorDirectory.equals(this._inputDirectory) && this._inputSuffix.equals(this._errorSuffix)) {
            throw new ConfigurationException("Error suffix must differ from input suffix <" + this._errorSuffix + ">");
        }
        String sPostDel = ListenerUtil.getValue(this.config, "postDelete", "false").trim();
        this._deleteAfterOK = Boolean.parseBoolean(sPostDel);
        if (this._deleteAfterOK) {
            return;
        }
        String sPostRename = ListenerUtil.getValue(this.config, "postRename", "true").trim();
        this._renameAfterOK = Boolean.parseBoolean(sPostRename);
        String sPostDir = ListenerUtil.getValue(this.config, "postDir", sInpDir);
        this._postProcessDirectory = AbstractFileGateway.fileFromString(sPostDir);
        this.seeIfOkToWorkOnDir(this._postProcessDirectory);
        this._postProcessSuffix = ListenerUtil.getValue(this.config, "postSuffix", ".esbDone").trim();
        if (this._postProcessDirectory.equals(this._inputDirectory)) {
            if (this._postProcessSuffix.length() < 1) {
                throw new ConfigurationException("Invalid postSuffix attribute");
            }
            if (this._postProcessSuffix.equals(this._inputSuffix)) {
                throw new ConfigurationException("Post process suffix must differ from input suffix <" + this._postProcessSuffix + ">");
            }
        }
    }

    public static File getFileInputDirectory(ConfigTree config) throws ConfigurationException {
        String sInpDir = AbstractFileGateway.getInputDir(config);
        return AbstractFileGateway.fileFromString(sInpDir);
    }

    private static String getInputDir(ConfigTree config) throws ConfigurationException {
        String uri = config.getAttribute("URL");
        if (uri != null) {
            try {
                return new URI(uri).getPath();
            }
            catch (URISyntaxException e) {
                throw new ConfigurationException("Invalid 'URL' value '" + uri + "'.  Must be a valid URI.");
            }
        }
        return config.getRequiredAttribute("inputDir");
    }

    private static File fileFromString(String file) {
        try {
            return new File(new URI(file));
        }
        catch (Exception e) {
            return new File(file);
        }
    }

    abstract File[] getFileList() throws GatewayException;

    abstract byte[] getFileContents(File var1) throws GatewayException;

    abstract boolean renameFile(File var1, File var2) throws GatewayException;

    abstract boolean deleteFile(File var1) throws GatewayException;

    abstract void seeIfOkToWorkOnDir(File var1) throws ConfigurationException;

    abstract String getDefaultComposer() throws ConfigurationException;

    abstract void bytesToFile(byte[] var1, File var2) throws GatewayException;

    private class LegacyFileMessageComposerAdapter<T extends File>
    extends LegacyMessageComposerAdapter<T> {
        private LegacyFileMessageComposerAdapter() {
        }

        @Override
        public Object decompose(Message message, T inputFile) throws MessageDeliverException {
            try {
                return this._responderMethod.invoke(this._composer, message, inputFile);
            }
            catch (IllegalAccessException e) {
                throw new MessageDeliverException("Legacy composer class ('" + this._composerClass.getName() + "') responder method '" + this._responderMethod.getName() + "' is not callable.", e);
            }
            catch (InvocationTargetException e) {
                throw new MessageDeliverException("Legacy composer class ('" + this._composerClass.getName() + "') responder method '" + this._responderMethod.getName() + "' failed with exception.", e.getCause());
            }
        }

        @Override
        public Class[] getResponderParameters() {
            return new Class[]{Message.class, File.class};
        }
    }
}

