/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.deployers.mc.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.virtual.MemoryFileFactory;
import org.jboss.virtual.VirtualFile;

public final class VfsUtil {
    private static final String IN_MEMORY_PROTOCOL = "vfsmemory";

    private VfsUtil() {
    }

    public static VirtualFile createInMemoryFs(URL rootUrl) throws IOException {
        return MemoryFileFactory.createRoot((URL)rootUrl).getRoot();
    }

    public static VirtualFile addFile(URL rootUrl, String filePath, byte[] fileContent) throws MalformedURLException {
        URL fileUrl = new URL(rootUrl + "/" + filePath);
        return MemoryFileFactory.putFile((URL)fileUrl, (byte[])fileContent);
    }

    public static URL createInMemUrl(String root) throws MalformedURLException {
        return new URL(IN_MEMORY_PROTOCOL, root, "");
    }

    public static URL createInMemUrl(String root, String path) throws MalformedURLException {
        return new URL(IN_MEMORY_PROTOCOL, root, "/" + path);
    }

    public static URL createInMemUrl(URL root, String path) throws MalformedURLException {
        return new URL(IN_MEMORY_PROTOCOL, root.getHost(), root.getPath() + "/" + path);
    }

    public static void addFiles(List<VirtualFile> files, URL destUrl, String subPath) throws IOException, URISyntaxException {
        VfsUtil.addFiles(files, destUrl, subPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFiles(List<VirtualFile> files, URL destUrl, String subPath, String pathPrefix) throws IOException, URISyntaxException {
        for (VirtualFile file : files) {
            InputStream in = null;
            try {
                in = file.openStream();
                URL newUrl = VfsUtil.createInMemUrl(destUrl.getHost(), VfsUtil.subpath(file.getPathName(), subPath, pathPrefix));
                MemoryFileFactory.putFile((URL)newUrl, (byte[])StreamUtils.readStream(in));
            }
            finally {
                in.close();
            }
        }
    }

    static String subpath(String path, String pathName, String pathPrefix) {
        if (path == null || pathName == null) {
            return path;
        }
        int idx = path.indexOf(pathName);
        String subpath = idx != -1 ? path.substring(idx + pathName.length()) : path;
        if (pathPrefix == null) {
            return subpath;
        }
        if (subpath.startsWith("/")) {
            return pathPrefix + subpath;
        }
        return pathPrefix + "/" + subpath;
    }

    static String subpath(String path, String pathName) {
        return VfsUtil.subpath(path, pathName, null);
    }
}

