/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.deployers.mc;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSStructureDeployer;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.util.collection.CollectionsFactory;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

public class GroupingStructure
extends AbstractVFSStructureDeployer {
    private static final String[] META_INF = new String[]{"META-INF"};
    private VirtualFileFilter shortCircuitFilter;
    private boolean rootClasspathEntry;
    private String[] metaDataPaths;
    private Set<String> libs;
    private Set<String> groups;
    private VirtualFileFilter libFilter;
    private VirtualFileFilter groupFilter;
    private Map<String, VirtualFileFilter> filters;

    public GroupingStructure() {
        this.setRelativeOrder(9000);
        this.setRootClasspathEntry(true);
        this.setLibs(Collections.<String>emptySet());
        this.setMetaDataPaths(META_INF);
        this.setGroups(CollectionsFactory.createLazySet());
        this.setFilters(Collections.<String, VirtualFileFilter>emptyMap());
    }

    public boolean determineStructure(StructureContext structureContext) throws DeploymentException {
        VirtualFile file = structureContext.getFile();
        if (!this.shortCircuitFileCheck(file)) {
            return false;
        }
        ContextInfo context = null;
        try {
            context = this.createContext(structureContext, this.metaDataPaths);
            if (this.rootClasspathEntry) {
                this.addClassPath(structureContext, file, true, true, context);
            }
            for (String lib : this.libs) {
                VirtualFile libVF = file.getChild(lib);
                if (libVF != null) {
                    VirtualFileFilter lf = this.filters.get(lib);
                    if (lf == null) {
                        lf = this.libFilter;
                    }
                    List archives = libVF.getChildren(lf);
                    for (VirtualFile archive : archives) {
                        this.addClassPath(structureContext, archive, true, true, context);
                    }
                    continue;
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.info((Object)("No such lib: " + lib + ", " + file));
            }
            for (String group : this.groups) {
                VirtualFile groupVF = file.getChild(group);
                if (groupVF != null) {
                    VirtualFileFilter gf = this.filters.get(group);
                    if (gf == null) {
                        gf = this.groupFilter;
                    }
                    List children = groupVF.getChildren(gf);
                    for (VirtualFile child : children) {
                        structureContext.determineChildStructure(child);
                    }
                    continue;
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.info((Object)("No such group: " + group + ", " + file));
            }
            return true;
        }
        catch (Exception e) {
            if (context != null) {
                structureContext.removeChild(context);
            }
            throw DeploymentException.rethrowAsDeploymentException((String)("Error determining structure: " + file.getName()), (Throwable)e);
        }
    }

    protected boolean shortCircuitFileCheck(VirtualFile file) {
        return this.shortCircuitFilter != null && this.shortCircuitFilter.accepts(file);
    }

    public void setShortCircuitFilter(VirtualFileFilter shortCircuitFilter) {
        this.shortCircuitFilter = shortCircuitFilter;
    }

    public void setRootClasspathEntry(boolean rootClasspathEntry) {
        this.rootClasspathEntry = rootClasspathEntry;
    }

    public void setLibs(Set<String> libs) {
        if (libs == null) {
            throw new IllegalArgumentException("Null libs");
        }
        this.libs = libs;
    }

    public void setLibFilter(VirtualFileFilter libFilter) {
        this.libFilter = libFilter;
    }

    public void setMetaDataPaths(String[] metaDataPaths) {
        this.metaDataPaths = metaDataPaths;
    }

    public void setGroups(Set<String> groups) {
        if (groups == null) {
            throw new IllegalArgumentException("Null groups");
        }
        this.groups = groups;
    }

    public void addGroup(String group) {
        this.groups.add(group);
    }

    public void removeGroup(String group) {
        this.groups.remove(group);
    }

    public void setGroupFilter(VirtualFileFilter groupFilter) {
        this.groupFilter = groupFilter;
    }

    public void setFilters(Map<String, VirtualFileFilter> filters) {
        if (filters == null) {
            throw new IllegalArgumentException("Null filters");
        }
        this.filters = filters;
    }
}

