/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.deployers.mc;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.internal.soa.esb.webservice.ESBContractGenerator;
import org.jboss.internal.soa.esb.webservice.ESBServiceEndpointInfo;
import org.jboss.soa.esb.listeners.config.WebserviceInfo;
import org.jboss.soa.esb.listeners.deployers.mc.EsbMetaData;
import org.jboss.soa.esb.listeners.deployers.mc.util.VfsUtil;
import org.jboss.virtual.MemoryFileFactory;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

public class EsbWsdlDeployer
extends AbstractSimpleVFSRealDeployer<EsbMetaData> {
    private Logger log = Logger.getLogger(EsbWsdlDeployer.class);
    static final String WSDL_LOCATIONS_KEY = "WSDL-LOCATIONS-KEY";
    static final String DYNAMIC_ROOT_URL_KEY = "WSDL-DYNAMIC-ROOT-URL";
    static final String DYNAMIC_ROOT_DIR_KEY = "WSDL-DYNAMIC-ROOT-DIR";
    private static final VirtualFileFilter schemaFileFilter = new SchemaFileFilter();

    public EsbWsdlDeployer() {
        super(EsbMetaData.class);
        this.setStage(DeploymentStages.POST_CLASSLOADER);
    }

    public void deploy(VFSDeploymentUnit unit, EsbMetaData esbMetaData) throws DeploymentException {
        List<WebserviceInfo> webServices = esbMetaData.getModel().getWebserviceServices();
        if (webServices != null && webServices.size() > 0) {
            try {
                String inMemRootName = esbMetaData.getDeploymentName() + "_WSDL";
                URL inMemRootUrl = VfsUtil.createInMemUrl(inMemRootName);
                VirtualFile inMemRootDir = VfsUtil.createInMemoryFs(inMemRootUrl);
                unit.addAttachment(DYNAMIC_ROOT_URL_KEY, (Object)inMemRootUrl);
                unit.addAttachment(DYNAMIC_ROOT_DIR_KEY, (Object)inMemRootDir);
                ArrayList<URL> wsdls = new ArrayList<URL>();
                if (webServices.size() > 0) {
                    for (WebserviceInfo wsInfo : webServices) {
                        ESBServiceEndpointInfo serviceInfo = new ESBServiceEndpointInfo(wsInfo);
                        String wsdl = ESBContractGenerator.generateWSDL(wsInfo, serviceInfo, unit.getClassLoader());
                        URL wsdlUrl = VfsUtil.createInMemUrl(inMemRootUrl, serviceInfo.getWSDLFileName());
                        this.log.info((Object)("Generating wsdl url : " + wsdlUrl));
                        VirtualFile wsdlFile = VfsUtil.addFile(inMemRootUrl, serviceInfo.getWSDLFileName(), wsdl.getBytes());
                        wsdls.add(wsdlUrl);
                        this.addSchemasToVfs(this.getSchemas(unit.getRoot()), wsdlFile.getParent(), esbMetaData.getArchiveName());
                    }
                    unit.appendMetaDataLocation(new VirtualFile[]{inMemRootDir});
                }
                unit.addAttachment(WSDL_LOCATIONS_KEY, wsdls);
            }
            catch (Exception e) {
                throw new DeploymentException("Failed to create webservice artifact", (Throwable)e);
            }
        }
    }

    List<VirtualFile> getSchemas(VirtualFile root) throws IOException {
        return root.getChildrenRecursively(schemaFileFilter);
    }

    void addSchemasToVfs(List<VirtualFile> schemas, VirtualFile toVfs, String archiveName) throws MalformedURLException, IOException, URISyntaxException {
        VfsUtil.addFiles(schemas, toVfs.toURL(), archiveName, "WEB-INF/wsdl/" + toVfs.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(VFSDeploymentUnit unit, EsbMetaData esbMetaData) {
        block9: {
            try {
                List locations = (List)unit.removeAttachment(WSDL_LOCATIONS_KEY, List.class);
                if (locations == null) break block9;
                for (URL url : locations) {
                    MemoryFileFactory.delete((URL)url);
                }
            }
            catch (Throwable throwable) {
                try {
                    URL rootUrl = (URL)unit.removeAttachment(DYNAMIC_ROOT_URL_KEY, URL.class);
                    if (rootUrl != null) {
                        MemoryFileFactory.deleteRoot((URL)rootUrl);
                        unit.removeMetaDataLocation(new VirtualFile[]{VFS.getVFS((URL)rootUrl).getRoot()});
                    }
                }
                catch (Exception e) {
                    this.log.warn((Object)("Error deleting dynamic class root for " + unit.getName()), (Throwable)e);
                }
                throw throwable;
            }
        }
        try {
            URL rootUrl = (URL)unit.removeAttachment(DYNAMIC_ROOT_URL_KEY, URL.class);
            if (rootUrl != null) {
                MemoryFileFactory.deleteRoot((URL)rootUrl);
                unit.removeMetaDataLocation(new VirtualFile[]{VFS.getVFS((URL)rootUrl).getRoot()});
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Error deleting dynamic class root for " + unit.getName()), (Throwable)e);
        }
    }

    private static class SchemaFileFilter
    implements VirtualFileFilter {
        private SchemaFileFilter() {
        }

        public boolean accepts(VirtualFile file) {
            return file.getName().endsWith(".xsd");
        }
    }
}

