/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.deployers.mc;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.internal.soa.esb.listeners.war.Filter;
import org.jboss.internal.soa.esb.listeners.war.SecurityConstraints;
import org.jboss.internal.soa.esb.listeners.war.Servlet;
import org.jboss.internal.soa.esb.listeners.war.WebModel;
import org.jboss.internal.soa.esb.publish.ContractReferencePublisher;
import org.jboss.internal.soa.esb.util.JBossDeployerUtil;
import org.jboss.internal.soa.esb.webservice.ESBResponseFilter;
import org.jboss.internal.soa.esb.webservice.ESBServiceContractReferencePublisher;
import org.jboss.internal.soa.esb.webservice.ESBServiceEndpointInfo;
import org.jboss.internal.soa.esb.webservice.JAXWSProviderClassGenerator;
import org.jboss.internal.soa.esb.webservice.WebServicePublishException;
import org.jboss.metadata.common.jboss.WebserviceDescriptionMetaData;
import org.jboss.metadata.common.jboss.WebserviceDescriptionsMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.AuthConstraintMetaData;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.TransportGuaranteeType;
import org.jboss.metadata.web.spec.UserDataConstraintMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionsMetaData;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.listeners.config.ModelUtil;
import org.jboss.soa.esb.listeners.config.WebserviceInfo;
import org.jboss.soa.esb.listeners.deployers.mc.EsbMetaData;
import org.jboss.soa.esb.listeners.deployers.mc.util.VfsUtil;
import org.jboss.virtual.MemoryFileFactory;
import org.jboss.virtual.VirtualFile;

public class EsbWebServiceDeployer
extends AbstractSimpleVFSRealDeployer<EsbMetaData> {
    private Logger log = Logger.getLogger(EsbWebServiceDeployer.class);
    static final String DYNAMIC_CL_DIR_KEY = "WS-DYNAMIC-CL-DIR";
    static final String DYNAMIC_CL_URL_KEY = "WS-DYNAMIC-CL-URL";
    static final String DYNAMIC_WEBINF_CL_DIR_KEY = "WS-WEBINF-DYNAMIC-CL-DIR";
    static final String DYNAMIC_WEBINF_CL_URL_KEY = "WS-WEBINF-DYNAMIC-CL-URL";

    public EsbWebServiceDeployer() {
        super(EsbMetaData.class);
        this.setStage(DeploymentStages.POST_PARSE);
        this.setOutput(JBossWebMetaData.class);
        this.setOutput(EsbMetaData.class);
    }

    public void deploy(VFSDeploymentUnit unit, EsbMetaData esbMetaData) throws DeploymentException {
        boolean webMetaDataCreated = false;
        JBossWebMetaData webMetaData = new JBossWebMetaData();
        JBossServletsMetaData servlets = new JBossServletsMetaData();
        ArrayList<ServletMappingMetaData> servletMappings = new ArrayList<ServletMappingMetaData>();
        FiltersMetaData filters = new FiltersMetaData();
        ArrayList<FilterMappingMetaData> filterMappings = new ArrayList<FilterMappingMetaData>();
        ArrayList<ContractReferencePublisher> publishers = new ArrayList<ContractReferencePublisher>();
        ArrayList<SecurityConstraintMetaData> securityConstraintsMDs = new ArrayList<SecurityConstraintMetaData>();
        WebserviceDescriptionsMetaData descriptions = new WebserviceDescriptionsMetaData();
        List<WebserviceInfo> webServices = esbMetaData.getModel().getWebserviceServices();
        if (this.hasWebServices(webServices)) {
            webMetaDataCreated = true;
            this.log.debug((Object)("Deploying webservices for : " + esbMetaData.getDeploymentName()));
            try {
                URL inMemRootUrl = VfsUtil.createInMemUrl(esbMetaData.getDeploymentName());
                VirtualFile inMemRootDir = VfsUtil.createInMemoryFs(inMemRootUrl);
                unit.addAttachment(DYNAMIC_CL_DIR_KEY, (Object)inMemRootDir);
                unit.addAttachment(DYNAMIC_CL_URL_KEY, (Object)inMemRootUrl);
                unit.addClassPath(new VirtualFile[]{inMemRootDir});
                URL classesUrl = VfsUtil.createInMemUrl(inMemRootUrl, "WEB-INF/classes");
                VirtualFile classesDir = MemoryFileFactory.createDirectory((URL)classesUrl);
                unit.addAttachment(DYNAMIC_WEBINF_CL_DIR_KEY, (Object)classesDir);
                unit.addAttachment(DYNAMIC_WEBINF_CL_URL_KEY, (Object)classesUrl);
                unit.addClassPath(new VirtualFile[]{classesDir});
                JAXWSProviderClassGenerator generator = new JAXWSProviderClassGenerator();
                for (WebserviceInfo wsInfo : webServices) {
                    boolean includeHandlers;
                    ESBServiceEndpointInfo serviceInfo = new ESBServiceEndpointInfo(wsInfo);
                    String handlers = JBossDeployerUtil.getHandlers(serviceInfo);
                    boolean bl = includeHandlers = handlers != null;
                    if (includeHandlers) {
                        unit.appendMetaDataLocation(new VirtualFile[]{classesDir});
                        String wsHandlerName = serviceInfo.getPackageName().replace('.', '/') + "/esb-jaxws-handlers.xml";
                        VfsUtil.addFile(classesUrl, wsHandlerName, handlers.getBytes());
                    }
                    if (serviceInfo.isOneWay()) {
                        FilterMetaData filter = this.createFilter(serviceInfo);
                        filters.add((MappableMetaData)filter);
                        filterMappings.add(this.createFilterMapping(serviceInfo, filter));
                    }
                    Service service = wsInfo.getService();
                    byte[] servletClass = generator.generate(service.getCategory(), service.getName(), serviceInfo, includeHandlers);
                    String servletClassName = serviceInfo.getClassName().replace('.', '/') + ".class";
                    URL servletClassUrl = VfsUtil.createInMemUrl(classesUrl, servletClassName);
                    VfsUtil.addFile(classesUrl, servletClassName, servletClass);
                    this.log.debug((Object)("Generated ServletImpl '" + servletClassUrl + "'"));
                    servlets.add((MappableMetaData)this.createServlets(serviceInfo, generator, includeHandlers));
                    servletMappings.add(this.createServletMapping(serviceInfo));
                    WebserviceDescriptionMetaData description = new WebserviceDescriptionMetaData();
                    description.setName(esbMetaData.getDeploymentName());
                    description.setWebserviceDescriptionName(esbMetaData.getDeploymentName());
                    description.setWsdlPublishLocation(serviceInfo.getWSDLFileName());
                    descriptions.add((MappableMetaData)description);
                    ESBServiceContractReferencePublisher publisher = new ESBServiceContractReferencePublisher(service, wsInfo.getDescription(), serviceInfo.getServletName());
                    publishers.add(publisher);
                }
            }
            catch (Exception e) {
                throw new DeploymentException("Failed to create webservice artifact", (Throwable)e);
            }
        }
        WebModel webModel = new WebModel(esbMetaData.getArchiveName());
        try {
            webModel.setAuthDomain(esbMetaData.getModel().getAuthDomain());
            webModel.setAuthMethod(esbMetaData.getModel().getAuthMethod());
            ModelUtil.updateWebModel(ModelUtil.getListenerGroups(esbMetaData.getModel()), webModel);
        }
        catch (ConfigurationException e) {
            throw new DeploymentException("Failed to capture web metadata from ESB configuration.", (Throwable)e);
        }
        for (Filter filter : webModel.getFilters()) {
            webMetaDataCreated = true;
            filters.add((MappableMetaData)this.createFilter(filter));
            filterMappings.add(this.createFilterMapping(filter));
        }
        for (Servlet servlet : webModel.getServlets()) {
            AuthConstraintMetaData constraint;
            webMetaDataCreated = true;
            servlets.add((MappableMetaData)this.createServlet(servlet));
            servletMappings.add(this.createServletMapping(servlet));
            SecurityConstraints securityConstraints = servlet.getSecurityConstraints();
            if (securityConstraints == null) continue;
            SecurityConstraintMetaData securityConstraintMD = new SecurityConstraintMetaData();
            securityConstraintsMDs.add(securityConstraintMD);
            securityConstraintMD.setDisplayName("Constraints for servlet '" + servlet.getName() + "'.");
            WebResourceCollectionsMetaData resources = new WebResourceCollectionsMetaData();
            WebResourceCollectionMetaData resource = new WebResourceCollectionMetaData();
            resources.add((Object)resource);
            securityConstraintMD.setResourceCollections(resources);
            resource.setHttpMethods(new ArrayList<String>(securityConstraints.getProtectedMethods()));
            resource.setUrlPatterns(servlet.getUrlMappings());
            if (!securityConstraints.getAllowedRoles().isEmpty()) {
                constraint = new AuthConstraintMetaData();
                constraint.setRoleNames(new ArrayList<String>(securityConstraints.getAllowedRoles()));
                securityConstraintMD.setAuthConstraint(constraint);
            }
            if (securityConstraints.getTransportGuarantee() == null) continue;
            constraint = new UserDataConstraintMetaData();
            constraint.setTransportGuarantee(TransportGuaranteeType.valueOf((String)securityConstraints.getTransportGuarantee()));
            securityConstraintMD.setUserDataConstraint((UserDataConstraintMetaData)constraint);
        }
        esbMetaData.setServlets(webModel.getServlets());
        if (webModel.getAuthMethod() != null) {
            LoginConfigMetaData loginConfig = new LoginConfigMetaData();
            loginConfig.setAuthMethod(webModel.getAuthMethod());
            loginConfig.setRealmName("Authentication Realm for '" + esbMetaData.getArchiveName() + "'");
            webMetaData.setLoginConfig(loginConfig);
        }
        if (webModel.getAuthDomain() != null) {
            webMetaData.setSecurityDomain(webModel.getAuthDomain());
        }
        if (!webModel.getSecurityRoles().isEmpty()) {
            SecurityRolesMetaData secRolesMetaData = new SecurityRolesMetaData();
            webMetaData.setSecurityRoles(secRolesMetaData);
            for (String role : webModel.getSecurityRoles()) {
                SecurityRoleMetaData secRoleMetaData = new SecurityRoleMetaData();
                secRoleMetaData.setRoleName(role);
                secRolesMetaData.add((MappableMetaData)secRoleMetaData);
            }
        }
        if (webMetaDataCreated) {
            webMetaData.setContextRoot(esbMetaData.getDeploymentName());
            webMetaData.setServlets(servlets);
            webMetaData.setServletMappings(servletMappings);
            webMetaData.setFilters(filters);
            webMetaData.setFilterMappings(filterMappings);
            webMetaData.setWebserviceDescriptions(descriptions);
            webMetaData.setSecurityContraints(securityConstraintsMDs);
            esbMetaData.setPublishers(publishers);
            unit.addAttachment(JBossWebMetaData.class, (Object)webMetaData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(VFSDeploymentUnit unit, EsbMetaData esbMetaData) {
        try {
            this.removeVirtualFile(unit, DYNAMIC_CL_DIR_KEY);
            this.removeVirtualFile(unit, DYNAMIC_WEBINF_CL_DIR_KEY);
        }
        finally {
            try {
                this.removeFromClassPath(unit, DYNAMIC_WEBINF_CL_URL_KEY);
                this.removeFromClassPath(unit, DYNAMIC_CL_URL_KEY);
            }
            catch (Exception e) {
                this.log.warn((Object)("Error deleting dynamic class root for " + unit.getName()), (Throwable)e);
            }
        }
    }

    private void removeVirtualFile(VFSDeploymentUnit unit, String attachmenKey) {
        VirtualFile file = (VirtualFile)unit.removeAttachment(attachmenKey, VirtualFile.class);
        if (file != null) {
            unit.removeClassPath(new VirtualFile[]{file});
        }
    }

    private void removeFromClassPath(VFSDeploymentUnit unit, String attachmentKey) {
        URL url = (URL)unit.removeAttachment(attachmentKey, URL.class);
        if (url != null) {
            MemoryFileFactory.delete((URL)url);
        }
    }

    private boolean hasWebServices(List<WebserviceInfo> endpointServices) {
        return endpointServices != null && endpointServices.size() > 0;
    }

    private ServletMappingMetaData createServletMapping(ESBServiceEndpointInfo serviceInfo) {
        ServletMappingMetaData mapping = new ServletMappingMetaData();
        mapping.setServletName(serviceInfo.getServletName());
        mapping.setUrlPatterns(Arrays.asList("/ebws" + serviceInfo.getServletPath()));
        return mapping;
    }

    private JBossServletMetaData createServlets(ESBServiceEndpointInfo serviceInfo, JAXWSProviderClassGenerator generator, boolean includeHandlers) throws WebServicePublishException {
        JBossServletMetaData servlet = new JBossServletMetaData();
        servlet.setServletName(serviceInfo.getServletName());
        servlet.setServletClass(serviceInfo.getClassName());
        servlet.setLoadOnStartup(1);
        return servlet;
    }

    private FilterMetaData createFilter(ESBServiceEndpointInfo serviceInfo) {
        FilterMetaData filter = new FilterMetaData();
        filter.setFilterName(serviceInfo.getServletName() + "_Filter");
        filter.setFilterClass(ESBResponseFilter.class.getName());
        ParamValueMetaData oneWayInitParam = new ParamValueMetaData();
        oneWayInitParam.setParamName("OneWay");
        oneWayInitParam.setParamValue("true");
        filter.setInitParam(Arrays.asList(oneWayInitParam));
        return filter;
    }

    private FilterMappingMetaData createFilterMapping(ESBServiceEndpointInfo serviceInfo, FilterMetaData filter) {
        FilterMappingMetaData mapping = new FilterMappingMetaData();
        mapping.setFilterName(filter.getFilterName());
        mapping.setServletNames(Arrays.asList(serviceInfo.getServletName()));
        return mapping;
    }

    private JBossServletMetaData createServlet(Servlet servlet) {
        JBossServletMetaData servletMD = new JBossServletMetaData();
        servletMD.setServletName(servlet.getName());
        servletMD.setServletClass(servlet.getRuntimeClass());
        servletMD.setLoadOnStartup(1);
        List<ParamValueMetaData> initParamsMetaData = this.createParamsMetaData(servlet.getParams());
        if (initParamsMetaData != null) {
            servletMD.setInitParam(initParamsMetaData);
        }
        return servletMD;
    }

    private ServletMappingMetaData createServletMapping(Servlet servlet) {
        ServletMappingMetaData mapping = new ServletMappingMetaData();
        mapping.setServletName(servlet.getName());
        mapping.setUrlPatterns(servlet.getUrlMappings());
        return mapping;
    }

    private FilterMetaData createFilter(Filter filter) {
        FilterMetaData filterMetaData = new FilterMetaData();
        filterMetaData.setFilterName(filter.getName());
        filterMetaData.setFilterClass(filter.getRuntimeClass());
        List<ParamValueMetaData> initParamsMetaData = this.createParamsMetaData(filter.getParams());
        if (initParamsMetaData != null) {
            filterMetaData.setInitParam(initParamsMetaData);
        }
        return filterMetaData;
    }

    private List<ParamValueMetaData> createParamsMetaData(List<KeyValuePair> initParams) {
        ArrayList<ParamValueMetaData> initParamsMetaData = null;
        if (!initParams.isEmpty()) {
            initParamsMetaData = new ArrayList<ParamValueMetaData>();
            for (KeyValuePair initParam : initParams) {
                ParamValueMetaData initParamMetaData = new ParamValueMetaData();
                initParamMetaData.setParamName(initParam.getKey());
                initParamMetaData.setParamValue(initParam.getValue());
                initParamsMetaData.add(initParamMetaData);
            }
        }
        return initParamsMetaData;
    }

    private FilterMappingMetaData createFilterMapping(Filter filter) {
        FilterMappingMetaData mapping = new FilterMappingMetaData();
        mapping.setFilterName(filter.getName());
        mapping.setServletNames(Arrays.asList(filter.getTargetServlet().getName()));
        return mapping;
    }
}

