/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.deployers.mc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.listeners.war.Servlet;
import org.jboss.internal.soa.esb.publish.ContractReferencePublisher;
import org.jboss.soa.esb.listeners.config.model.ModelAdapter;

public class EsbMetaData
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String archiveName;
    private final String esbConfigXml;
    private final Set<ObjectName> dependencies;
    private final String deploymentName;
    private ModelAdapter model;
    private List<ContractReferencePublisher> publishers = new ArrayList<ContractReferencePublisher>();
    private List<Servlet> servlets = new ArrayList<Servlet>();

    public EsbMetaData(String esbConfigXml, String archiveName, String deploymentName, Set<ObjectName> dependencies, ModelAdapter model) {
        AssertArgument.isNotNullAndNotEmpty(esbConfigXml, "esbConfigXml");
        AssertArgument.isNotNullAndNotEmpty(archiveName, "archiveName");
        AssertArgument.isNotNullAndNotEmpty(deploymentName, "deploymentName");
        this.esbConfigXml = esbConfigXml;
        this.archiveName = archiveName;
        this.deploymentName = deploymentName;
        this.dependencies = dependencies;
        this.model = model;
    }

    public final String getArchiveName() {
        return this.archiveName;
    }

    public String getEsbConfigXml() {
        return this.esbConfigXml;
    }

    public Set<ObjectName> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public ModelAdapter getModel() {
        return this.model;
    }

    public void setPublishers(List<ContractReferencePublisher> publishers) {
        this.publishers = publishers;
    }

    public List<ContractReferencePublisher> getPublishers() {
        return Collections.unmodifiableList(this.publishers);
    }

    public void setServlets(List<Servlet> servlets) {
        this.servlets = servlets;
    }

    public List<Servlet> getServlets() {
        return Collections.unmodifiableList(this.servlets);
    }

    public final String toString() {
        return String.format("EsbMetaData [archiveName='%s', deploymentName='%s', dependencies='%s']", this.archiveName, this.deploymentName, this.dependencies);
    }
}

