/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.deployers.mc;

import java.util.List;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.listeners.war.Servlet;
import org.jboss.internal.soa.esb.publish.ContractReferencePublisher;
import org.jboss.soa.esb.lifecycle.LifecycleResourceManager;
import org.jboss.soa.esb.listeners.config.Configuration;
import org.jboss.soa.esb.listeners.config.ServicePublisher;
import org.jboss.soa.esb.listeners.deployers.mc.EsbDeploymentMBean;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleController;

public class EsbDeployment
implements EsbDeploymentMBean {
    private Logger log = Logger.getLogger(EsbDeployment.class);
    private final String jbossEsbXml;
    private String deploymentName;
    private List<ContractReferencePublisher> publishers;
    private List<Servlet> servlets;
    private ManagedLifecycleController controller;
    private final String mbeanName;

    public EsbDeployment(String config, String deploymentName, String mbeanName) throws Exception {
        this.jbossEsbXml = config;
        this.deploymentName = deploymentName;
        this.mbeanName = mbeanName;
    }

    @Override
    public String getJbossEsbXml() {
        return this.jbossEsbXml;
    }

    @Override
    public String getJbossEsbXmlAsHtml() {
        return this.jbossEsbXml.replace("<", "&lt;").replace(">", "&gt;");
    }

    public void setPublishers(List<ContractReferencePublisher> publishers) {
        this.publishers = publishers;
    }

    public void setServlets(List<Servlet> servlets) {
        this.servlets = servlets;
    }

    public List<Servlet> getServlets() {
        return this.servlets;
    }

    public ManagedLifecycleController getController() {
        return this.controller;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public List<ContractReferencePublisher> getPublishers() {
        return this.publishers;
    }

    public void create() {
        LifecycleResourceManager.getSingleton().associateDeployment(this.deploymentName);
        LifecycleResourceManager.deactivateHook();
    }

    @Override
    public void start() throws Exception {
        if (this.controller == null) {
            this.log.info((Object)("Starting ESB Deployment '" + this.deploymentName + "'"));
            this.controller = Configuration.create(this.jbossEsbXml, new ObjectName(this.mbeanName), this.publishers, this.servlets);
            this.controller.start();
        }
    }

    @Override
    public boolean isStarted() {
        return this.controller != null;
    }

    @Override
    public void stop() throws Exception {
        if (this.controller != null) {
            this.log.info((Object)("Stopping '" + this.deploymentName + "'"));
            ServicePublisher.removeServicePublishers(this.controller);
            this.controller.stop();
            this.controller = null;
        }
    }

    public void destroy() throws Exception {
        this.log.info((Object)("Destroying '" + this.deploymentName + "'"));
        LifecycleResourceManager.getSingleton().disassociateDeployment(this.deploymentName);
        LifecycleResourceManager.getSingleton().destroyResources();
    }
}

