/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.deployers.mc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.soa.esb.listeners.deployers.mc.EsbDeployment;
import org.jboss.soa.esb.listeners.deployers.mc.EsbMetaData;

public class EsbDeployer
extends AbstractSimpleVFSRealDeployer<EsbMetaData> {
    private Logger log = Logger.getLogger(EsbDeployer.class);
    private String esbBeanPrefix = "jboss.esb";
    private List<String> defaultDeps = new ArrayList<String>();

    public EsbDeployer() {
        super(EsbMetaData.class);
        this.setOutput(BeanMetaData.class);
        this.setStage(DeploymentStages.POST_CLASSLOADER);
    }

    public final void deploy(VFSDeploymentUnit deploymentUnit, EsbMetaData esbMetaData) throws DeploymentException {
        try {
            BeanMetaData beanMetaData = this.createBeanMetaData(deploymentUnit, esbMetaData);
            deploymentUnit.addAttachment(BeanMetaData.class.getName() + "_ESB", (Object)beanMetaData);
            this.log.debug((Object)("Created beanMetaData : " + beanMetaData));
        }
        catch (org.jboss.deployment.DeploymentException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    private BeanMetaData createBeanMetaData(VFSDeploymentUnit deploymentUnit, EsbMetaData esbMetaData) throws org.jboss.deployment.DeploymentException, IOException {
        this.log.debug((Object)esbMetaData);
        BeanMetaDataBuilder bmdBuilder = BeanMetaDataBuilder.createBuilder((String)(this.esbBeanPrefix + "." + deploymentUnit.getName()), (String)EsbDeployment.class.getName());
        bmdBuilder.addConstructorParameter(String.class.getName(), esbMetaData.getEsbConfigXml());
        bmdBuilder.addConstructorParameter(String.class.getName(), esbMetaData.getArchiveName());
        String mbeanName = this.esbBeanPrefix + ":deployment=" + deploymentUnit.getSimpleName();
        bmdBuilder.addConstructorParameter(String.class.getName(), mbeanName);
        bmdBuilder.addAnnotation("@org.jboss.aop.microcontainer.aspects.jmx.JMX(registerDirectly=true, exposedInterface=void.class, name=\"" + mbeanName + "\")");
        for (String dependency : this.defaultDeps) {
            bmdBuilder.addDependency((Object)dependency);
        }
        Set<ObjectName> dependencies = esbMetaData.getDependencies();
        for (ObjectName objectName : dependencies) {
            this.log.debug((Object)("Adding depend " + objectName.toString() + " for " + esbMetaData.getDeploymentName()));
            bmdBuilder.addDemand((Object)objectName.toString(), ControllerState.PRE_INSTALL, ControllerState.INSTALLED, null);
        }
        if (esbMetaData.getPublishers().size() > 0) {
            this.log.debug((Object)("Adding publishers : " + esbMetaData.getPublishers()));
            bmdBuilder.addPropertyMetaData("publishers", esbMetaData.getPublishers());
        }
        if (esbMetaData.getServlets().size() > 0) {
            this.log.debug((Object)("Adding servlets : " + esbMetaData.getServlets()));
            bmdBuilder.addPropertyMetaData("servlets", esbMetaData.getServlets());
        }
        return bmdBuilder.getBeanMetaData();
    }

    public void setEsbBeanPrefix(String prefix) {
        this.esbBeanPrefix = prefix;
    }

    public String getEsbBeanPrefix() {
        return this.esbBeanPrefix;
    }

    public void setDefaultDependencies(List<String> deps) {
        if (deps != null) {
            this.defaultDeps.addAll(deps);
        }
    }

    public List<String> getDefaultDependencies() {
        return Collections.unmodifiableList(this.defaultDeps);
    }
}

