/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers120;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.config.mappers120.XMLBeansModel;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.CronScheduleDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.FrequencyUnit;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.Schedule;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.ScheduleProviderDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.SimpleScheduleDocument;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycle;
import org.jboss.soa.esb.schedule.CronSchedule;
import org.jboss.soa.esb.schedule.ScheduleProvider;
import org.jboss.soa.esb.schedule.ScheduledEventListener;
import org.jboss.soa.esb.schedule.SchedulingException;
import org.jboss.soa.esb.schedule.SimpleSchedule;

public abstract class ScheduleProviderFactory {
    public static final String ATTR_SCHEDULE_ID_REF = "scheduleidref";
    public static final String ATTR_FREQUENCY = "schedule-frequency";

    public static ScheduleProvider createInstance(List<ManagedLifecycle> listeners, ScheduleProviderDocument.ScheduleProvider scheduleProviderConfig) throws ConfigurationException {
        Properties schedulerConfig = null;
        List<org.jboss.soa.esb.schedule.Schedule> schedules = null;
        if (scheduleProviderConfig != null) {
            schedulerConfig = XMLBeansModel.toProperties(scheduleProviderConfig.getPropertyList());
            schedules = ScheduleProviderFactory.getSchedules(scheduleProviderConfig);
        }
        ScheduleProvider instance = new ScheduleProvider(schedulerConfig, schedules);
        try {
            for (ManagedLifecycle listener : listeners) {
                if (!(listener instanceof ScheduledEventListener)) continue;
                ConfigTree config = listener.getConfig();
                String scheduleIdRef = config.getAttribute(ATTR_SCHEDULE_ID_REF);
                if (scheduleIdRef != null) {
                    instance.addListener((ScheduledEventListener)((Object)listener), scheduleIdRef);
                    continue;
                }
                long frequency = config.getLongAttribute(ATTR_FREQUENCY, 10L);
                instance.addListener((ScheduledEventListener)((Object)listener), frequency);
            }
        }
        catch (SchedulingException e) {
            throw new ConfigurationException(e);
        }
        return instance;
    }

    private static List<org.jboss.soa.esb.schedule.Schedule> getSchedules(ScheduleProviderDocument.ScheduleProvider scheduleProviderConfig) throws ConfigurationException {
        ArrayList<org.jboss.soa.esb.schedule.Schedule> schedules = new ArrayList<org.jboss.soa.esb.schedule.Schedule>();
        List scheduleConfigs = scheduleProviderConfig.getScheduleList();
        ArrayList<String> schedulIds = new ArrayList<String>();
        for (Schedule scheduleConfig : scheduleConfigs) {
            org.jboss.soa.esb.schedule.Schedule schedule;
            String scheduleId = scheduleConfig.getScheduleid();
            if (schedulIds.contains(scheduleId)) {
                throw new ConfigurationException("Duplicate 'scheduleid' value of '" + scheduleId + "'.  Must be unique on a per <schedule-provider> basis.");
            }
            schedulIds.add(scheduleId);
            if (scheduleConfig instanceof SimpleScheduleDocument.SimpleSchedule) {
                FrequencyUnit.Enum frequencyUnit = ((SimpleScheduleDocument.SimpleSchedule)scheduleConfig).getFrequencyUnits();
                SimpleSchedule simpleSchedule = new SimpleSchedule(scheduleId);
                schedule = simpleSchedule;
                if (frequencyUnit == FrequencyUnit.SECONDS) {
                    simpleSchedule.setFrequency(((SimpleScheduleDocument.SimpleSchedule)scheduleConfig).getFrequency() * 1000L);
                } else {
                    simpleSchedule.setFrequency(((SimpleScheduleDocument.SimpleSchedule)scheduleConfig).getFrequency());
                }
                simpleSchedule.setExecCount(((SimpleScheduleDocument.SimpleSchedule)scheduleConfig).getExecCount());
            } else {
                CronSchedule cronSchedule = new CronSchedule(scheduleId);
                schedule = cronSchedule;
                cronSchedule.setCronExpression(((CronScheduleDocument.CronSchedule)scheduleConfig).getCronExpression());
            }
            schedule.setStartDate(scheduleConfig.getStartDate());
            schedule.setEndDate(scheduleConfig.getEndDate());
            schedules.add(schedule);
        }
        return schedules;
    }
}

