/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers120;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.listeners.war.HttpGatewayDeploymentFactory;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.mappers120.MapperUtil;
import org.jboss.soa.esb.listeners.config.mappers120.XMLBeansModel;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.AsyncHttpResponse;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.Bus;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.HttpBusDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.HttpExceptionMappings;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.HttpGatewayDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.HttpProviderDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.Listener;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.PayloadAs;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.PropertyDocument;
import org.jboss.soa.esb.util.ClassUtil;
import org.w3c.dom.Element;

public class HttpGatewayMapper {
    private static final Logger logger = Logger.getLogger(HttpGatewayMapper.class);

    public static Element map(Element root, HttpGatewayDocument.HttpGateway listener, XMLBeansModel model) throws ConfigurationException {
        HttpBusDocument.HttpBus bus;
        Element listenerNode = YADOMUtil.addElement(root, "listener");
        listenerNode.setAttribute("name", listener.getName());
        try {
            bus = (HttpBusDocument.HttpBus)model.getOptionalBus(listener.getBusidref());
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid busid reference [" + listener.getBusidref() + "] on listener [" + listener.getName() + "].  A <http-listener> must reference a <http-bus>.");
        }
        MapperUtil.mapDefaultAttributes((Listener)listener, listenerNode, model);
        String urlPattern = listener.getUrlPattern();
        PayloadAs.Enum payloadAs = listener.getPayloadAs();
        if (listener.getAsyncResponseList() != null && !listener.getAsyncResponseList().isEmpty()) {
            AsyncHttpResponse asyncResponse = (AsyncHttpResponse)listener.getAsyncResponseList().get(0);
            listenerNode.setAttribute("asyncServiceInvoke", "true");
            listenerNode.setAttribute("asyncStatusCode", Integer.toString(asyncResponse.getStatusCode()));
            AsyncHttpResponse.Payload payload = asyncResponse.getPayload();
            if (payload != null) {
                listenerNode.setAttribute("asyncPayloadPath", payload.getClasspathResource());
                listenerNode.setAttribute("asyncPayloadContentType", payload.getContentType());
                if (payload.getCharacterEncoding() != null) {
                    listenerNode.setAttribute("asyncPayloadCharacterEncoding", payload.getCharacterEncoding());
                }
            }
        } else {
            listenerNode.setAttribute("asyncServiceInvoke", "false");
        }
        if (bus != null) {
            HttpProviderDocument.HttpProvider provider;
            try {
                provider = (HttpProviderDocument.HttpProvider)model.getProvider((Bus)bus);
            }
            catch (ClassCastException e) {
                throw new ConfigurationException("Invalid bus config [" + listener.getBusidref() + "].  Should be contained within a <http-provider> instance.  Unexpected exception - this should have caused a validation error!");
            }
            for (PropertyDocument.Property property : provider.getPropertyList()) {
                Element propertyElement = listenerNode.getOwnerDocument().createElement("property");
                MapperUtil.serialize((XmlObject)property, propertyElement);
                listenerNode.appendChild(propertyElement);
            }
            List protectedMethodsList = bus.getProtectedMethodsList();
            List rolesList = bus.getAllowedRolesList();
            HttpBusDocument.HttpBus.TransportGuarantee.Enum transportGuarantee = bus.getTransportGuarantee();
            MapperUtil.mapProperties(bus.getPropertyList(), listenerNode);
            HttpGatewayMapper.mapStandardSettings(listenerNode, urlPattern, payloadAs, listener.getPropertyList());
            if (protectedMethodsList != null && !protectedMethodsList.isEmpty()) {
                HttpBusDocument.HttpBus.ProtectedMethods methods = (HttpBusDocument.HttpBus.ProtectedMethods)protectedMethodsList.get(0);
                StringBuilder methodsString = new StringBuilder();
                for (HttpBusDocument.HttpBus.ProtectedMethods.Method method : methods.getMethodList()) {
                    if (methodsString.length() > 0) {
                        methodsString.append(",");
                    }
                    methodsString.append(method.getName().toString());
                }
                listenerNode.setAttribute("protectedMethods", methodsString.toString());
            }
            if (rolesList != null && !rolesList.isEmpty()) {
                HttpBusDocument.HttpBus.AllowedRoles roles = (HttpBusDocument.HttpBus.AllowedRoles)rolesList.get(0);
                StringBuilder rolesString = new StringBuilder();
                for (HttpBusDocument.HttpBus.AllowedRoles.Role role : roles.getRoleList()) {
                    if (rolesString.length() > 0) {
                        rolesString.append(",");
                    }
                    rolesString.append(role.getName());
                }
                listenerNode.setAttribute("allowedRoles", rolesString.toString());
            }
            if (transportGuarantee != null) {
                listenerNode.setAttribute("transportGuarantee", transportGuarantee.toString());
            }
            HttpGatewayMapper.mapExceptionStatusMappings(listenerNode, provider, listener);
        } else {
            HttpGatewayMapper.mapStandardSettings(listenerNode, urlPattern, payloadAs, listener.getPropertyList());
            HttpGatewayMapper.mapExceptionStatusMappings(listenerNode, (HttpProviderDocument.HttpProvider)model.getProvider(HttpProviderDocument.HttpProvider.class), listener);
        }
        return listenerNode;
    }

    private static void mapStandardSettings(Element listenerNode, String urlPattern, PayloadAs.Enum payloadAs, List<PropertyDocument.Property> listenerProps) {
        MapperUtil.mapProperties(listenerProps, listenerNode);
        listenerNode.setAttribute("gatewayClass", HttpGatewayDeploymentFactory.class.getName());
        listenerNode.setAttribute("is-gateway", "true");
        if (urlPattern != null) {
            listenerNode.setAttribute("urlPattern", urlPattern);
        }
        if (payloadAs != null) {
            listenerNode.setAttribute("payloadAs", payloadAs.toString());
        }
    }

    private static void mapExceptionStatusMappings(Element listenerNode, HttpProviderDocument.HttpProvider provider, HttpGatewayDocument.HttpGateway listener) throws ConfigurationException {
        HttpExceptionMappings providerExceptionConfig;
        StringBuilder exceptionMappingsAttrBuilder = new StringBuilder();
        if (provider != null && (providerExceptionConfig = provider.getException()) != null) {
            HttpGatewayMapper.buildExceptionMappingCSV(exceptionMappingsAttrBuilder, providerExceptionConfig);
        }
        if (listener != null && listener.getExceptionList() != null && !listener.getExceptionList().isEmpty()) {
            HttpExceptionMappings listenerExceptionConfig = (HttpExceptionMappings)listener.getExceptionList().get(0);
            HttpGatewayMapper.buildExceptionMappingCSV(exceptionMappingsAttrBuilder, listenerExceptionConfig);
        }
        if (exceptionMappingsAttrBuilder.length() > 0) {
            listenerNode.setAttribute("httpExceptionMappings", exceptionMappingsAttrBuilder.toString());
        }
    }

    private static void buildExceptionMappingCSV(StringBuilder exceptionMappingsAttrBuilder, HttpExceptionMappings exceptionConfig) throws ConfigurationException {
        List mappings;
        String mappingsFile = exceptionConfig.getMappingsFile();
        if (mappingsFile != null) {
            exceptionMappingsAttrBuilder.append(mappingsFile);
            exceptionMappingsAttrBuilder.append(",");
        }
        if ((mappings = exceptionConfig.getMappingList()) != null && !mappings.isEmpty()) {
            for (HttpExceptionMappings.Mapping mapping : mappings) {
                exceptionMappingsAttrBuilder.append(mapping.getClass1().trim());
                exceptionMappingsAttrBuilder.append("=");
                exceptionMappingsAttrBuilder.append(mapping.getStatus());
                exceptionMappingsAttrBuilder.append(",");
            }
        }
    }

    public static Map<String, Integer> decodeExceptionMappingsCSV(String exceptionMappingsCSV) throws ConfigurationException {
        String[] mappingDecls;
        AssertArgument.isNotNullAndNotEmpty(exceptionMappingsCSV, "exceptionMappingsCSV");
        HashMap<String, Integer> mappings = new HashMap<String, Integer>();
        for (String mappingDecl : mappingDecls = exceptionMappingsCSV.split(",")) {
            String[] mappingTokens = mappingDecl.split("=");
            if (mappingTokens.length == 1) {
                HttpGatewayMapper.loadExceptionMappings(mappingTokens[0], mappings);
                continue;
            }
            if (mappingTokens.length == 2) {
                try {
                    mappings.put(mappingTokens[0], Integer.valueOf(mappingTokens[1]));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ConfigurationException("Invalid Exception Status Mapping mapping declaration '" + mappingDecl + "'.  Status code value '" + mappingTokens[1] + "' not a valid integer.");
                }
            }
            throw new ConfigurationException("Invalid Exception Status Mapping mapping declaration '" + mappingDecl + "'.  Expected either an exception mapping file name, or a '<exception>=<status>' Key Value Pair.");
        }
        return mappings;
    }

    private static void loadExceptionMappings(String mappingsFile, Map<String, Integer> mappings) throws ConfigurationException {
        Properties mappingProperties = new Properties();
        InputStream stream = ClassUtil.getResourceAsStream(mappingsFile, HttpGatewayMapper.class);
        if (stream == null) {
            throw new ConfigurationException("Failed to find Exception to HTTP Status code mappings file '" + mappingsFile + "' on classpath.");
        }
        try {
            mappingProperties.load(stream);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading Exception to HTTP Status code mappings file '" + mappingsFile + "'.", e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.debug((Object)("Error closing Exception to HTTP Status code mappings file '" + mappingsFile + "'."), (Throwable)e);
            }
        }
        Set<Map.Entry<Object, Object>> entries = mappingProperties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            try {
                mappings.put((String)entry.getKey(), Integer.valueOf((String)entry.getValue()));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Invalid Exception Status Mapping mapping '" + entry.getKey() + "=" + entry.getValue() + "'.  Status code value '" + entry.getValue() + "' not a valid integer.");
            }
        }
    }
}

