/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers120;

import java.util.List;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.mappers120.MapperUtil;
import org.jboss.soa.esb.listeners.config.mappers120.XMLBeansModel;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.Bus;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.HibernateBusDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.HibernateListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.HibernateMessageFilterDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.HibernateProviderDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.Listener;
import org.jboss.soa.esb.listeners.gateway.HibernateGatewayListener;
import org.w3c.dom.Element;

public class HibernateListenerMapper {
    public static Element map(Element root, HibernateListenerDocument.HibernateListener listener, XMLBeansModel model) throws ConfigurationException {
        HibernateProviderDocument.HibernateProvider provider;
        HibernateBusDocument.HibernateBus bus;
        Element listenerNode = YADOMUtil.addElement(root, "listener");
        listenerNode.setAttribute("name", listener.getName());
        try {
            bus = (HibernateBusDocument.HibernateBus)model.getBus(listener.getBusidref());
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid busid reference [" + listener.getBusidref() + "] on listener [" + listener.getName() + "].  A <hibernate-listener> must reference a <hibernate-bus>.");
        }
        try {
            provider = (HibernateProviderDocument.HibernateProvider)model.getProvider((Bus)bus);
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid bus config [" + listener.getBusidref() + "].  Should be contained within a <hibernate-provider> instance.  Unexpected exception - this should have caused a validation error!");
        }
        List messageFilters = null;
        messageFilters = listener.getHibernateMessageFilterList();
        if (messageFilters.size() == 0 && (messageFilters = bus.getHibernateMessageFilterList()) == null) {
            throw new ConfigurationException("No <hibernate-message-filter> defined on either <hibernate-listener> [" + listener.getName() + "] or <hibernate-bus> [" + bus.getBusid() + "].");
        }
        MapperUtil.mapDefaultAttributes((Listener)listener, listenerNode, model);
        MapperUtil.mapProperties(listener.getPropertyList(), listenerNode);
        if (listener.getIsGateway()) {
            listenerNode.setAttribute("gatewayClass", HibernateGatewayListener.class.getName());
            HibernateListenerMapper.mapHibernateEprProperties(listenerNode, provider, messageFilters);
            MapperUtil.mapEPRProperties((Listener)listener, listenerNode, model);
        } else {
            Element eprNode = YADOMUtil.addElement(listenerNode, "EPR");
            HibernateListenerMapper.mapHibernateEprProperties(eprNode, provider, messageFilters);
            MapperUtil.mapEPRProperties((Listener)listener, eprNode, model);
            YADOMUtil.removeEmptyAttributes(eprNode);
        }
        YADOMUtil.removeEmptyAttributes(listenerNode);
        return listenerNode;
    }

    private static void mapHibernateEprProperties(Element toElement, HibernateProviderDocument.HibernateProvider provider, List<HibernateMessageFilterDocument.HibernateMessageFilter> messageFilters) {
        toElement.setAttribute("hibernate-cfg-file", provider.getHibernateCfgFile());
        for (HibernateMessageFilterDocument.HibernateMessageFilter messageFilter : messageFilters) {
            Element temp = YADOMUtil.addElement(toElement, "messagefilter");
            temp.setAttribute("classname", messageFilter.getClassname());
            temp.setAttribute("event", messageFilter.getEvent());
            toElement.appendChild(temp);
        }
    }
}

