/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers110;

import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.mappers110.MapperUtil;
import org.jboss.soa.esb.listeners.config.mappers110.XMLBeansModel;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.AbstractScheduledListener;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.CronScheduleDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.FrequencyUnit;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.PropertyDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.Schedule;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.ScheduleProviderDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.SimpleScheduleDocument;
import org.w3c.dom.Element;

public class ScheduleMapper {
    private static Logger logger = Logger.getLogger(ScheduleMapper.class);

    public static void map(Element listenerConfig, AbstractScheduledListener scheduledListener, XMLBeansModel model) throws ConfigurationException {
        String scheduleIdRef = scheduledListener.getScheduleidref();
        Element domElement = (Element)scheduledListener.getDomNode();
        int scheduleFrequency = scheduledListener.getScheduleFrequency();
        int pollFrequency = scheduledListener.getPollFrequencySeconds();
        int pollLatency = ScheduleMapper.getPollLatencySeconds(scheduledListener);
        if (scheduleIdRef != null) {
            listenerConfig.setAttribute("scheduleidref", scheduleIdRef);
            Schedule schedule = model.getSchedule(scheduleIdRef);
            if (schedule.isSetStartDate()) {
                listenerConfig.setAttribute("scheduleStartDate", Long.toString(schedule.getStartDate().getTimeInMillis()));
            }
            if (schedule.isSetEndDate()) {
                listenerConfig.setAttribute("scheduleEndDate", Long.toString(schedule.getEndDate().getTimeInMillis()));
            }
            if (schedule instanceof SimpleScheduleDocument.SimpleSchedule) {
                SimpleScheduleDocument.SimpleSchedule simpleSchedule = (SimpleScheduleDocument.SimpleSchedule)schedule;
                long simpleFrequency = simpleSchedule.getFrequency();
                FrequencyUnit.Enum unit = simpleSchedule.getFrequencyUnits();
                String frequencyVal = unit.equals(FrequencyUnit.SECONDS) ? Long.toString(simpleFrequency * 1000L) : Long.toString(simpleFrequency);
                listenerConfig.setAttribute("scheduleSimpleFrequency", frequencyVal);
                if (simpleSchedule.isSetExecCount()) {
                    listenerConfig.setAttribute("scheduleSimpleExec", Integer.toString(simpleSchedule.getExecCount()));
                }
            } else if (schedule instanceof CronScheduleDocument.CronSchedule) {
                String cronExpression = ((CronScheduleDocument.CronSchedule)schedule).getCronExpression();
                if (cronExpression == null) {
                    throw new ConfigurationException("Missing cron expression from configuration");
                }
                listenerConfig.setAttribute("scheduleCronExpression", cronExpression);
            } else {
                throw new ConfigurationException("Unknown schedule type specified in configuration: " + schedule.getClass().getName());
            }
            if (domElement.hasAttribute("poll-frequency-seconds") || domElement.hasAttribute("schedule-frequency")) {
                logger.warn((Object)("Schedule Listener '" + listenerConfig.getTagName() + "' defines both 'scheduleidref' and frequency attributes.  Using the 'scheduleidref'."));
            }
        } else if (scheduleFrequency > -1) {
            listenerConfig.setAttribute("schedule-frequency", Integer.toString(scheduleFrequency));
        } else if (pollFrequency > -1) {
            listenerConfig.setAttribute("schedule-frequency", Integer.toString(pollFrequency));
        } else if (pollLatency > -1) {
            listenerConfig.setAttribute("schedule-frequency", Integer.toString(pollLatency));
        } else {
            listenerConfig.setAttribute("schedule-frequency", "10");
        }
        ScheduleProviderDocument.ScheduleProvider scheduleProvider = model.getScheduleProvider();
        if (scheduleProvider != null) {
            ScheduleMapper.copyProperties(listenerConfig, model.getScheduleProvider().getPropertyList(), model.getScheduledListenerCount());
        }
        if (domElement.hasAttribute("poll-frequency-seconds")) {
            logger.warn((Object)"Attrubute 'poll-frequency-seconds' is DEPRECATED.  Please change your configuration to use 'schedule-frequency'.");
        }
        if (pollLatency > -1) {
            logger.warn((Object)"Property 'pollLatencySeconds' is DEPRECATED.  Please change your configuration to use 'schedule-frequency'.");
        }
    }

    private static void copyProperties(Element listenerConfig, List<PropertyDocument.Property> properties, int numScheduledListeners) {
        Element schedulePropertyElement = YADOMUtil.addElement(listenerConfig, "ScheduleProperties");
        schedulePropertyElement.setAttribute("org.quartz.threadPool.threadCount", Integer.toString(numScheduledListeners));
        if (properties != null && properties.size() > 0) {
            MapperUtil.mapProperties(properties, schedulePropertyElement);
        }
    }

    private static int getPollLatencySeconds(AbstractScheduledListener scheduledListener) {
        String value = XMLBeansModel.getProperty(scheduledListener.getPropertyList(), "pollLatencySeconds", "-1");
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

