/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers110;

import com.arjuna.common.util.propertyservice.PropertyManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.mappers110.MapperUtil;
import org.jboss.soa.esb.listeners.config.mappers110.XMLBeansModel;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.ActivationConfigDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.Bus;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.JmsBusDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.JmsJcaProviderDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.JmsListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.JmsMessageFilterDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.JmsProviderType;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.Listener;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.PropertyDocument;
import org.jboss.soa.esb.listeners.gateway.JmsGatewayListener;
import org.jboss.soa.esb.listeners.gateway.PackageJmsMessageContents;
import org.jboss.soa.esb.listeners.jca.ActivationMapper;
import org.jboss.soa.esb.listeners.jca.JcaGatewayListener;
import org.jboss.soa.esb.listeners.jca.JcaJMSInflowMessageProcessorAdapter;
import org.jboss.soa.esb.listeners.jca.JcaJMSMessageAwareComposer;
import org.jboss.soa.esb.listeners.jca.JcaMessageAwareListener;
import org.jboss.soa.esb.util.ClassUtil;
import org.w3c.dom.Element;

public class JmsListenerMapper {
    private static final String DEFAULT_JMS_ADAPTER = "jms-ra.rar";
    private static Logger log = Logger.getLogger(JmsListenerMapper.class);

    public static Element map(Element root, JmsListenerDocument.JmsListener listener, XMLBeansModel model) throws ConfigurationException {
        Class gatewayClass;
        JmsProviderType provider;
        JmsBusDocument.JmsBus bus;
        Element listenerNode = YADOMUtil.addElement(root, "listener");
        listenerNode.setAttribute("name", listener.getName());
        try {
            bus = (JmsBusDocument.JmsBus)model.getBus(listener.getBusidref());
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid busid reference [" + listener.getBusidref() + "] on listener [" + listener.getName() + "].  A <jms-listener> must reference a <jms-bus>.");
        }
        try {
            provider = (JmsProviderType)model.getProvider((Bus)bus);
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid bus config [" + listener.getBusidref() + "].  Should be contained within a <jms-provider> instance.  Unexpected exception - this should have caused a validation error!");
        }
        JmsMessageFilterDocument.JmsMessageFilter messageFilter = listener.getJmsMessageFilter();
        if (messageFilter == null && (messageFilter = bus.getJmsMessageFilter()) == null) {
            throw new ConfigurationException("No <jms-detination> defined on either <jms-listener> [" + listener.getName() + "] or <jms-bus> [" + bus.getBusid() + "].");
        }
        if (provider instanceof JmsJcaProviderDocument.JmsJcaProvider) {
            JmsJcaProviderDocument.JmsJcaProvider jmsJcaProvider = (JmsJcaProviderDocument.JmsJcaProvider)provider;
            JmsListenerMapper.mapJmsJcaAttributes(listener, listenerNode, bus, jmsJcaProvider, messageFilter);
            gatewayClass = JcaGatewayListener.class;
        } else {
            gatewayClass = JmsGatewayListener.class;
        }
        MapperUtil.mapDefaultAttributes((Listener)listener, listenerNode, model);
        MapperUtil.mapProperties(listener.getPropertyList(), listenerNode);
        if (listener.getIsGateway()) {
            listenerNode.setAttribute("gatewayClass", gatewayClass.getName());
            listenerNode.setAttribute("is-gateway", Boolean.toString(listener.getIsGateway()));
            JmsListenerMapper.mapJmsEprProperties(listenerNode, provider, messageFilter);
            listenerNode.setAttribute("protocol", "jms");
            MapperUtil.mapEPRProperties((Listener)listener, listenerNode, model);
        } else {
            Element eprNode = YADOMUtil.addElement(listenerNode, "EPR");
            JmsListenerMapper.mapJmsEprProperties(eprNode, provider, messageFilter);
            eprNode.setAttribute("protocol", "jms");
            MapperUtil.mapEPRProperties((Listener)listener, eprNode, model);
            YADOMUtil.removeEmptyAttributes(eprNode);
        }
        YADOMUtil.removeEmptyAttributes(listenerNode);
        return listenerNode;
    }

    private static void mapJmsEprProperties(Element toElement, JmsProviderType provider, JmsMessageFilterDocument.JmsMessageFilter messageFilter) {
        if (messageFilter.getDestType() == JmsMessageFilterDocument.JmsMessageFilter.DestType.QUEUE) {
            toElement.setAttribute("destination-type", "queue");
        } else {
            toElement.setAttribute("destination-type", "topic");
        }
        toElement.setAttribute("destination-name", messageFilter.getDestName());
        toElement.setAttribute("message-selector", messageFilter.getSelector());
        toElement.setAttribute("connection-factory", provider.getConnectionFactory());
        toElement.setAttribute("jndi-context-factory", provider.getJndiContextFactory());
        toElement.setAttribute("jndi-pkg-prefix", provider.getJndiPkgPrefix());
        toElement.setAttribute("jndi-URL", provider.getJndiURL());
        toElement.setAttribute("persistent", Boolean.toString(messageFilter.getPersistent()));
        toElement.setAttribute("acknowledge-mode", messageFilter.getAcknowledgeMode());
        toElement.setAttribute("jms-security-principal", messageFilter.getJmsSecurityPrincipal());
        toElement.setAttribute("jms-security-credential", messageFilter.getJmsSecurityCredential());
        toElement.setAttribute("transacted", Boolean.toString(messageFilter.getTransacted()));
    }

    private static void mapJmsJcaAttributes(JmsListenerDocument.JmsListener listener, Element listenerNode, JmsBusDocument.JmsBus bus, JmsJcaProviderDocument.JmsJcaProvider jmsJcaProvider, JmsMessageFilterDocument.JmsMessageFilter messageFilter) throws ConfigurationException {
        JmsListenerMapper.setAttribute(listenerNode, "adapter", jmsJcaProvider.getAdapter(), DEFAULT_JMS_ADAPTER);
        JmsListenerMapper.setAttribute(listenerNode, "endpointClass", jmsJcaProvider.getEndpointClass(), JcaJMSInflowMessageProcessorAdapter.class.getName());
        JmsListenerMapper.setAttribute(listenerNode, "messagingType", jmsJcaProvider.getMessagingType());
        JmsListenerMapper.setAttribute(listenerNode, "jcaBridge", jmsJcaProvider.getJcaBridge());
        boolean transacted = jmsJcaProvider.isSetTransacted() ? jmsJcaProvider.getTransacted() : true;
        JmsListenerMapper.setAttribute(listenerNode, "transacted", Boolean.toString(transacted));
        if (listener.getIsGateway()) {
            JmsListenerMapper.setAttribute(listenerNode, "composer-class", PackageJmsMessageContents.class.getName());
            JmsListenerMapper.setAttribute(listenerNode, "composer-process", "process");
        } else {
            JmsListenerMapper.setAttribute(listenerNode, "listenerClass", JcaMessageAwareListener.class.getName());
            JmsListenerMapper.setAttribute(listenerNode, "listener-composer", JcaJMSMessageAwareComposer.class.getName());
        }
        ActivationMapper activationMapper = JmsListenerMapper.getActivationMapper(listener, bus, jmsJcaProvider);
        HashMap<String, String> activationConfigValues = new HashMap<String, String>();
        activationMapper.setDestination(activationConfigValues, messageFilter.getDestName());
        activationMapper.setProviderAdapterJNDI(activationConfigValues, jmsJcaProvider.getProviderAdapterJNDI());
        int destType = messageFilter.getDestType().intValue();
        if (destType == 1) {
            activationMapper.setDestinationType(activationConfigValues, true);
        } else if (destType == 2) {
            activationMapper.setDestinationType(activationConfigValues, false);
        } else {
            throw new ConfigurationException("Unknown destination type: " + messageFilter.getDestType());
        }
        activationMapper.setMessageSelector(activationConfigValues, messageFilter.getSelector());
        Integer maxThreads = listener.isSetMaxThreads() ? Integer.valueOf(listener.getMaxThreads()) : null;
        activationMapper.setMaxThreads(activationConfigValues, maxThreads);
        Element activationConfigElement = YADOMUtil.addElement(listenerNode, "activation-config");
        for (Map.Entry entry : activationConfigValues.entrySet()) {
            JmsListenerMapper.addPropertyElement(activationConfigElement, (String)entry.getKey(), (String)entry.getValue());
        }
        Set defaultPropertyNames = activationConfigValues.keySet();
        log.debug((Object)("Default activation-config properties :" + defaultPropertyNames));
        ActivationConfigDocument.ActivationConfig activationConfig = jmsJcaProvider.getActivationConfig();
        if (activationConfig != null) {
            List propertyList = activationConfig.getPropertyList();
            for (PropertyDocument.Property prop : propertyList) {
                if (defaultPropertyNames.contains(prop.getName())) {
                    throw new ConfigurationException("activation-config already contains [" + prop.getName() + "], which cannot be overridden");
                }
                JmsListenerMapper.addPropertyElement(activationConfigElement, prop.getName(), prop.getValue());
            }
        }
    }

    private static void setAttribute(Element listenerNode, String name, String value) {
        if (value != null) {
            listenerNode.setAttribute(name, value);
        }
    }

    private static void setAttribute(Element listenerNode, String name, String value, String defaultValue) {
        if (value == null) {
            listenerNode.setAttribute(name, defaultValue);
        } else {
            listenerNode.setAttribute(name, value);
        }
    }

    private static void addPropertyElement(Element activationConfigElement, String name, String value) {
        Element propertyElement = YADOMUtil.addElement(activationConfigElement, "property");
        propertyElement.setAttribute("name", name);
        propertyElement.setAttribute("value", value);
    }

    private static ActivationMapper getActivationMapper(JmsListenerDocument.JmsListener listener, JmsBusDocument.JmsBus bus, JmsJcaProviderDocument.JmsJcaProvider jmsJcaProvider) throws ConfigurationException {
        Class activationMapperClass;
        String activationMapper = JmsListenerMapper.getActivationMapperClass(listener, bus, jmsJcaProvider);
        if (activationMapper == null) {
            throw new ConfigurationException("Could not locate ActivationMapper for adapter " + jmsJcaProvider.getAdapter());
        }
        try {
            activationMapperClass = ClassUtil.forName(activationMapper.trim(), JmsListenerMapper.class);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConfigurationException("Could not locate activation mapper class " + activationMapper, cnfe);
        }
        if (!ActivationMapper.class.isAssignableFrom(activationMapperClass)) {
            throw new ConfigurationException("Activation mapper class " + activationMapper + " does not implement ActivationMapper interface");
        }
        try {
            return (ActivationMapper)activationMapperClass.newInstance();
        }
        catch (Throwable th) {
            throw new ConfigurationException("Failed to instantiate activation mapper class " + activationMapper, th);
        }
    }

    private static String getActivationMapperClass(JmsListenerDocument.JmsListener listener, JmsBusDocument.JmsBus bus, JmsJcaProviderDocument.JmsJcaProvider jmsJcaProvider) throws ConfigurationException {
        String listenerActivationMapper = JmsListenerMapper.findProperty(listener.getPropertyList(), "jcaActivationMapper");
        if (listenerActivationMapper != null) {
            return listenerActivationMapper;
        }
        String busActivationMapper = JmsListenerMapper.findProperty(bus.getPropertyList(), "jcaActivationMapper");
        if (busActivationMapper != null) {
            return busActivationMapper;
        }
        String providerActivationMapper = JmsListenerMapper.findProperty(jmsJcaProvider.getPropertyList(), "jcaActivationMapper");
        if (providerActivationMapper != null) {
            return providerActivationMapper;
        }
        String adapter = jmsJcaProvider.getAdapter() == null ? DEFAULT_JMS_ADAPTER : jmsJcaProvider.getAdapter();
        PropertyManager propertyManager = ModulePropertyManager.getPropertyManager("jca");
        String activationMapper = propertyManager.getProperty("org.jboss.soa.esb.jca.activation.mapper." + adapter);
        if (activationMapper == null) {
            throw new ConfigurationException("Could not locate activation mapper for adapter " + adapter);
        }
        return activationMapper;
    }

    private static String findProperty(List<PropertyDocument.Property> properties, String name) {
        if (properties != null && name != null) {
            for (PropertyDocument.Property property : properties) {
                if (!name.equals(property.getName())) continue;
                return property.getValue();
            }
        }
        return null;
    }
}

