/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers;

import java.util.List;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.mappers.XMLBeansModel;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.ActionsDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.Bus;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.Listener;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.MepType;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.PropertyDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.Provider;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.ServiceDocument;
import org.jboss.soa.esb.listeners.message.MessageAwareListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class MapperUtil {
    protected static void mapDefaultAttributes(Listener listener, Element listenerNode, XMLBeansModel model) {
        String busIdRef;
        MepType.Enum mep;
        ActionsDocument.Actions actions;
        ServiceDocument.Service service = model.getService(listener);
        boolean isGateway = listener.getIsGateway();
        listenerNode.setAttribute("maxThreads", String.valueOf(listener.getMaxThreads()));
        MapperUtil.mapListenerServiceAttributes(listenerNode, service, isGateway);
        if (!isGateway && !listenerNode.hasAttribute("listenerClass")) {
            listenerNode.setAttribute("listenerClass", MessageAwareListener.class.getName());
        }
        if ((actions = service.getActions()) != null && (mep = actions.getMep()) != null) {
            listenerNode.setAttribute("mep", mep.toString());
        }
        if ((busIdRef = listener.getBusidref()) != null) {
            listenerNode.setAttribute("busIdRef", busIdRef);
        }
    }

    public static void mapListenerServiceAttributes(Element listenerNode, ServiceDocument.Service service, boolean isGateway) {
        listenerNode.setAttribute("service-description", service.getDescription());
        if (isGateway) {
            listenerNode.setAttribute("target-service-category", service.getCategory());
            listenerNode.setAttribute("target-service-name", service.getName());
        } else {
            listenerNode.setAttribute("service-category", service.getCategory());
            listenerNode.setAttribute("service-name", service.getName());
        }
    }

    protected static void mapEPRProperties(Listener listener, Element target, XMLBeansModel model) throws ConfigurationException {
        Bus bus = model.getBus(listener.getBusidref());
        Provider provider = model.getProvider(bus);
        MapperUtil.mapProperties(provider.getPropertyList(), target);
        MapperUtil.mapProperties(bus.getPropertyList(), target);
    }

    public static void mapProperties(List<PropertyDocument.Property> properties, Element target) {
        for (PropertyDocument.Property property : properties) {
            Element propertyElement = target.getOwnerDocument().createElement("property");
            MapperUtil.serialize((XmlObject)property, propertyElement);
            if (propertyElement.hasChildNodes()) {
                YADOMUtil.copyChildNodes(propertyElement, target);
                continue;
            }
            target.setAttribute(property.getName(), property.getValue());
        }
    }

    protected static void serialize(XmlObject xmlObject, Element toElement) {
        XmlCursor cursor = xmlObject.newCursor();
        MapperUtil.serialize(cursor, toElement);
        cursor.dispose();
    }

    private static void serialize(XmlCursor cursor, Element toElement) {
        Document doc = toElement.getOwnerDocument();
        while (true) {
            XmlCursor.TokenType token = cursor.toNextToken();
            switch (token.intValue()) {
                case 6: {
                    toElement.setAttribute(cursor.getName().getLocalPart(), cursor.getTextValue());
                    break;
                }
                case 8: {
                    toElement.appendChild(doc.createComment(cursor.getTextValue()));
                    break;
                }
                case 3: {
                    Element childElement = doc.createElement(cursor.getName().getLocalPart());
                    toElement.appendChild(childElement);
                    MapperUtil.serialize(cursor, childElement);
                    break;
                }
                case 5: {
                    toElement.appendChild(doc.createTextNode(cursor.getChars()));
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 4: {
                    return;
                }
            }
        }
    }
}

