/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.publish.ContractInfo;
import org.jboss.internal.soa.esb.publish.ContractPublisher;
import org.jboss.internal.soa.esb.publish.ServletContractPublisher;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.listeners.config.ServicePublisher;

public class ServicePublisherContractInfoCache {
    private final Map<Key, ContractInfo> CACHE = new ConcurrentHashMap<Key, ContractInfo>();

    public synchronized ContractInfo getContractInfo(ServicePublisher servicePublisher, EPR epr) {
        return this.getContractInfo(servicePublisher, epr, null);
    }

    public synchronized ContractInfo getContractInfo(ServicePublisher servicePublisher, EPR epr, HttpServletRequest request) {
        ContractPublisher contractPublisher;
        Key key = new Key(servicePublisher, epr, request);
        ContractInfo value = this.CACHE.get(key);
        if (value == null && (contractPublisher = servicePublisher.getContractPublisher()) != null && (value = contractPublisher instanceof ServletContractPublisher && request != null ? ((ServletContractPublisher)contractPublisher).getContractInfo(epr, request) : contractPublisher.getContractInfo(epr)) != null) {
            this.CACHE.put(key, value);
        }
        return value;
    }

    public synchronized void removeContractInfos(ServicePublisher servicePublisher) {
        Set<Key> keySet = this.CACHE.keySet();
        for (Key key : keySet) {
            if (!key.servicePublisher.equals(servicePublisher)) continue;
            keySet.remove(key);
        }
    }

    private static class Key {
        private ServicePublisher servicePublisher;
        private EPR epr;
        private String serviceCat;
        private String serviceName;
        private String protocol;

        private Key(ServicePublisher servicePublisher, EPR epr, HttpServletRequest request) {
            AssertArgument.isNotNull(servicePublisher, "servicePublisher");
            AssertArgument.isNotNull(epr, "epr");
            this.servicePublisher = servicePublisher;
            this.epr = epr;
            this.serviceCat = Key.getParameter(request, "serviceCat");
            this.serviceName = Key.getParameter(request, "serviceName");
            this.protocol = Key.getParameter(request, "protocol");
        }

        private static String getParameter(HttpServletRequest request, String name) {
            String value = null;
            if (request != null && (value = request.getParameter(name)) != null && (value = value.trim()).length() == 0) {
                value = null;
            }
            return value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.epr == null ? other.epr != null : !this.epr.equals(other.epr)) {
                return false;
            }
            if (this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol)) {
                return false;
            }
            if (this.serviceCat == null ? other.serviceCat != null : !this.serviceCat.equals(other.serviceCat)) {
                return false;
            }
            if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
                return false;
            }
            return !(this.servicePublisher == null ? other.servicePublisher != null : !this.servicePublisher.equals(other.servicePublisher));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.epr == null ? 0 : this.epr.hashCode());
            result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
            result = 31 * result + (this.serviceCat == null ? 0 : this.serviceCat.hashCode());
            result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
            result = 31 * result + (this.servicePublisher == null ? 0 : this.servicePublisher.hashCode());
            return result;
        }
    }
}

