/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.internal.soa.esb.listeners.war.WebGatewayDeploymentFactory;
import org.jboss.internal.soa.esb.listeners.war.WebModel;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.config.model.ModelAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ModelUtil {
    public static Map<String, List<ConfigTree>> getListenerGroups(ModelAdapter model) throws ConfigurationException {
        LinkedHashMap<String, List<ConfigTree>> listenerGroups = new LinkedHashMap<String, List<ConfigTree>>();
        Document gatewayConfig = model.generateGatewayConfig();
        NodeList nodeList = gatewayConfig.getDocumentElement().getChildNodes();
        int count = nodeList.getLength();
        for (int i = 0; i < count; ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeType() != 1) continue;
            Element listenerElement = (Element)child;
            String busIdRef = listenerElement.getAttribute("busIdRef");
            ArrayList<ConfigTree> listenerGroup = (ArrayList<ConfigTree>)listenerGroups.get(busIdRef);
            if (listenerGroup == null) {
                listenerGroup = new ArrayList<ConfigTree>();
                listenerGroups.put(busIdRef, listenerGroup);
            }
            listenerGroup.add(ConfigTree.fromElement(listenerElement));
        }
        return listenerGroups;
    }

    public static void updateWebModel(Map<String, List<ConfigTree>> listenerGroups, WebModel webModel) throws ConfigurationException {
        Set<Map.Entry<String, List<ConfigTree>>> listenerGroupEntries = listenerGroups.entrySet();
        for (Map.Entry<String, List<ConfigTree>> listenerGroup : listenerGroupEntries) {
            WebGatewayDeploymentFactory deploymentFactory;
            List<ConfigTree> listeners = listenerGroup.getValue();
            String gatewayClass = listeners.get(0).getAttribute("gatewayClass");
            if (gatewayClass == null || (deploymentFactory = WebGatewayDeploymentFactory.FactoryBuilder.createInstance(gatewayClass)) == null) continue;
            for (ConfigTree listenerConfig : listeners) {
                deploymentFactory.updateWebModel(listenerConfig, webModel);
            }
        }
    }
}

