/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config;

import java.util.List;
import org.jboss.internal.soa.esb.listeners.war.Servlet;
import org.jboss.internal.soa.esb.publish.ContractReferencePublisher;
import org.jboss.soa.esb.lifecycle.LifecycleResourceManager;
import org.jboss.soa.esb.listeners.config.Configuration;
import org.jboss.soa.esb.listeners.config.JBoss4ESBDeploymentMBean;
import org.jboss.soa.esb.listeners.config.ServicePublisher;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleController;
import org.jboss.system.ServiceMBeanSupport;

public class JBoss4ESBDeployment
extends ServiceMBeanSupport
implements JBoss4ESBDeploymentMBean {
    private final String jbossEsbXml;
    private String deploymentName;
    private List<ContractReferencePublisher> publishers;
    private List<Servlet> servlets;
    private ManagedLifecycleController controller;
    private ClassLoader classloader;

    public JBoss4ESBDeployment(String jbossEsbXml, String deploymentName) {
        this.jbossEsbXml = jbossEsbXml;
        this.deploymentName = deploymentName;
    }

    @Override
    public String getJbossEsbXml() {
        return this.jbossEsbXml;
    }

    @Override
    public String getJbossEsbXmlAsHtml() {
        return this.jbossEsbXml.replace("<", "&lt;").replace(">", "&gt;");
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public void setPublishers(List<ContractReferencePublisher> publishers) {
        this.publishers = publishers;
    }

    public void setServlets(List<Servlet> servlets) {
        this.servlets = servlets;
    }

    public List<Servlet> getServlets() {
        return this.servlets;
    }

    public ManagedLifecycleController getController() {
        return this.controller;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public List<ContractReferencePublisher> getPublishers() {
        return this.publishers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createService() {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            LifecycleResourceManager.getSingleton().associateDeployment(this.deploymentName);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startService() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            this.controller = Configuration.create(this.jbossEsbXml, this.serviceName, this.publishers, this.servlets);
            this.controller.start();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            ServicePublisher.removeServicePublishers(this.controller);
            this.controller.stop();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyService() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            LifecycleResourceManager.getSingleton().disassociateDeployment(this.deploymentName);
            LifecycleResourceManager.getSingleton().destroyResources();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

