/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.lifecycle.LifecycleResourceManager;
import org.jboss.soa.esb.listeners.LifecycleUtil;
import org.jboss.soa.esb.listeners.config.Generator;
import org.jboss.soa.esb.listeners.config.ServicePublisher;
import org.jboss.soa.esb.listeners.config.model.ModelAdapter;
import org.jboss.soa.esb.listeners.config.model.ModelParser;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleController;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.parameters.ParamRepositoryException;
import org.jboss.soa.esb.parameters.ParamRepositoryFactory;
import org.jboss.soa.esb.util.ClassUtil;
import org.xml.sax.SAXException;

public class ConfigurationController
implements Runnable {
    private static final int SLEEP_MILLIS = 1000;
    private static final int ENDED_MILLIS = 20000;
    private static final String JBOSSESB_XSD = "/jbossesb-1.0.1.xsd";
    private static final Logger mLogger = Logger.getLogger(ConfigurationController.class);
    private final Lock endedLock = new ReentrantLock();
    private final Condition endedChanged = this.endedLock.newCondition();
    private final Condition endRequested = this.endedLock.newCondition();
    private final String mConfigFileName;
    private final String mConfigName;
    private final String mValidationFileName;
    private final File mConfigDirectory;
    private final String mListenerConfigFile;
    private final String mGatewayConfigFile;
    private long mPreviousFileTimestamp;
    private boolean mIsEndRequested;
    private boolean ended;
    private ManagedLifecycleController controller;

    public static void main(String[] args) {
        ConfigurationController configurationController = new ConfigurationController(args[0], null);
        configurationController.run();
    }

    public ConfigurationController(String configFileName) {
        this(configFileName, null);
    }

    public ConfigurationController(String configFileName, String validationFileName) {
        this.mConfigFileName = configFileName;
        File configFile = new File(configFileName);
        String absolute = configFile.getAbsoluteFile().toURI().getPath();
        int separator = absolute.indexOf(58);
        this.mConfigName = separator >= 0 ? absolute.substring(separator + 1) : absolute;
        File parent = configFile.getParentFile();
        this.mConfigDirectory = null != parent ? parent : new File("");
        File listenerConfigFile = new File(this.mConfigDirectory, "jbossesb-listener.xml");
        this.mListenerConfigFile = listenerConfigFile.getAbsolutePath();
        File gatewayConfigFile = new File(this.mConfigDirectory, "jbossesb-gateway.xml");
        this.mGatewayConfigFile = gatewayConfigFile.getAbsolutePath();
        this.mValidationFileName = validationFileName == null ? JBOSSESB_XSD : validationFileName;
        this.processConfiguration();
    }

    protected String getListenerConfigFile() {
        return this.mListenerConfigFile;
    }

    protected String getGatewayConfigFile() {
        return this.mGatewayConfigFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        mLogger.info((Object)"Configuration Controller instance started.");
        try {
            if (this.mConfigFileName != null) {
                do {
                    this.processConfiguration();
                } while (!this.waitForRequestedEnd(1000L));
                this.stopController();
            } else {
                mLogger.fatal((Object)("The name of the configuran file was null: " + this.mConfigFileName));
            }
        }
        finally {
            LifecycleResourceManager.getSingleton().cleanupAllResources();
            mLogger.info((Object)"Exiting Config Controller...");
            this.setEnded(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEnded() {
        this.endedLock.lock();
        try {
            boolean bl = this.ended;
            return bl;
        }
        finally {
            this.endedLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnded(boolean ended) {
        this.endedLock.lock();
        try {
            this.ended = ended;
            this.endedChanged.signalAll();
        }
        finally {
            this.endedLock.unlock();
        }
    }

    public boolean waitUntilEnded() {
        return this.waitUntilEnded(20000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilEnded(long maxDelay) {
        long endTime = System.currentTimeMillis() + maxDelay;
        this.endedLock.lock();
        try {
            try {
                long delay;
                while (!this.ended && (delay = endTime - System.currentTimeMillis()) > 0L && this.endedChanged.await(delay, TimeUnit.MILLISECONDS)) {
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            boolean bl = this.ended;
            return bl;
        }
        finally {
            this.endedLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForRequestedEnd(long maxDelay) {
        long endTime = System.currentTimeMillis() + maxDelay;
        this.endedLock.lock();
        try {
            try {
                long delay;
                while (!this.mIsEndRequested && (delay = endTime - System.currentTimeMillis()) > 0L && this.endRequested.await(delay, TimeUnit.MILLISECONDS)) {
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            boolean bl = this.mIsEndRequested;
            return bl;
        }
        finally {
            this.endedLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestEnd() {
        this.endedLock.lock();
        try {
            this.mIsEndRequested = true;
            this.endRequested.signalAll();
        }
        finally {
            this.endedLock.unlock();
        }
    }

    private void processConfiguration() {
        if (this.isReloadNeeded()) {
            try {
                StreamSource validationInputSource = null;
                InputStream validationInputStream = ClassUtil.getResourceAsStream(this.mValidationFileName, this.getClass());
                if (validationInputStream == null) {
                    File validationFile = new File(this.mValidationFileName);
                    mLogger.debug((Object)("Validation file " + this.mValidationFileName + " exists?:" + validationFile.exists()));
                    try {
                        validationInputStream = new FileInputStream(validationFile);
                    }
                    catch (FileNotFoundException e) {
                        mLogger.error((Object)e.getMessage(), (Throwable)e);
                        throw new IllegalStateException("ESB validation file [" + new File(this.mValidationFileName).getAbsolutePath() + "] not found.", e);
                    }
                }
                if (validationInputStream == null) {
                    mLogger.warn((Object)("Could not obtain validation file " + this.mValidationFileName));
                } else {
                    mLogger.debug((Object)("Reading validation info from " + this.mValidationFileName));
                    validationInputSource = new StreamSource(validationInputStream);
                }
                mLogger.info((Object)"loading configuration..");
                String configXml = ParamRepositoryFactory.getInstance().get(this.mConfigFileName);
                mLogger.debug((Object)("Start validation on configXml=" + configXml));
                if (ModelParser.getParser().validate(new StringReader(configXml))) {
                    mLogger.debug((Object)("Configuration file " + this.mConfigFileName + " passed validation. Starting " + " the generation process of the jbossesb-listener.xml and the jbossesb-gateway.xml."));
                    Generator generator = new Generator(new ByteArrayInputStream(configXml.getBytes()));
                    generator.generate(this.mConfigDirectory);
                    mLogger.info((Object)"Parameter reload completed.");
                    this.stopController();
                    this.controller = this.startController(generator.getModel());
                }
            }
            catch (Exception e) {
                mLogger.error((Object)("The current versions of the jbossesb-listener.xml and/or jbossesb-gateway.xml are kept in place until the error is resolved: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public ManagedLifecycleController startController(ModelAdapter configModel) throws ParamRepositoryException, SAXException, ManagedLifecycleException, ConfigurationException {
        LifecycleResourceManager.getSingleton().associateDeployment(this.mConfigName);
        return ConfigurationController.startController(configModel, LifecycleUtil.getConfigTree(this.mListenerConfigFile), LifecycleUtil.getConfigTree(this.mGatewayConfigFile));
    }

    public static ManagedLifecycleController startController(ModelAdapter configModel, ConfigTree listenerConfig, ConfigTree gatewayConfig) throws ParamRepositoryException, SAXException, ManagedLifecycleException, ConfigurationException {
        List<ManagedLifecycle> instances = LifecycleUtil.getListeners(listenerConfig);
        instances.addAll(LifecycleUtil.getGateways(gatewayConfig));
        ManagedLifecycleController lifecycleController = new ManagedLifecycleController(instances);
        try {
            lifecycleController.start();
            ServicePublisher.addServicePublishers(lifecycleController, configModel.getServicePublishers());
        }
        catch (ManagedLifecycleException mle) {
            lifecycleController = null;
            mLogger.error((Object)"Unexpected exception starting controller", (Throwable)mle);
        }
        return lifecycleController;
    }

    private boolean isReloadNeeded() {
        File configFile = new File(this.mConfigFileName);
        if (configFile.exists()) {
            long currentFileTimestamp = configFile.lastModified();
            if (this.mPreviousFileTimestamp == 0L || currentFileTimestamp > this.mPreviousFileTimestamp) {
                if (mLogger.isDebugEnabled()) {
                    mLogger.debug((Object)("The previous timestamp on the file was: " + new Date(this.mPreviousFileTimestamp) + " the new timestamp on the file is: " + new Date(currentFileTimestamp)));
                }
                this.mPreviousFileTimestamp = currentFileTimestamp;
                return true;
            }
        } else {
            mLogger.error((Object)("The configuration file " + configFile + " could not be found."));
        }
        return false;
    }

    private void stopController() {
        ConfigurationController.stopController(this.controller);
        LifecycleResourceManager.getSingleton().disassociateDeployment(this.mConfigFileName);
        this.controller = null;
    }

    public static void stopController(ManagedLifecycleController lifecycleController) {
        if (lifecycleController != null) {
            try {
                ServicePublisher.removeServicePublishers(lifecycleController);
                lifecycleController.stop();
            }
            catch (ManagedLifecycleException mle) {
                mLogger.error((Object)"Unexpected exception stopping controller", (Throwable)mle);
            }
        }
    }
}

