/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.internal.soa.esb.listeners.war.Servlet;
import org.jboss.internal.soa.esb.publish.ContractProviderLifecycleResource;
import org.jboss.internal.soa.esb.publish.ContractReferencePublisher;
import org.jboss.internal.soa.esb.publish.DefaultContractReferencePublisher;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.LifecycleUtil;
import org.jboss.soa.esb.listeners.config.Generator;
import org.jboss.soa.esb.listeners.config.ServiceContract;
import org.jboss.soa.esb.listeners.config.ServicePublisher;
import org.jboss.soa.esb.listeners.config.model.ModelAdapter;
import org.jboss.soa.esb.listeners.config.model.ModelParser;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleController;

public class Configuration {
    public static String getStringFromStream(InputStream is) throws Exception {
        byte[] bytes = StreamUtils.readStream(is);
        return new String(bytes, "UTF-8");
    }

    public static ManagedLifecycleController create(URL jbossEsbXml) {
        String configXml = null;
        try {
            configXml = Configuration.getStringFromStream(jbossEsbXml.openStream());
            return Configuration.create(configXml);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load jbossesb.xml file: " + jbossEsbXml, e);
        }
    }

    public static String getMep(ConfigTree listenerConfig) {
        String mep = listenerConfig.getAttribute("mep");
        if (mep != null) {
            return mep;
        }
        return "RequestResponse";
    }

    public static ManagedLifecycleController create(String configXml) {
        return Configuration.create(configXml, null);
    }

    public static ManagedLifecycleController create(String configXml, ObjectName serviceName) {
        return Configuration.create(configXml, serviceName, null);
    }

    public static ManagedLifecycleController create(String configXml, ObjectName serviceName, List<ContractReferencePublisher> publishers) {
        return Configuration.create(configXml, serviceName, publishers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManagedLifecycleController create(String configXml, ObjectName serviceName, List<ContractReferencePublisher> publishers, List<Servlet> servlets) {
        if (publishers == null) {
            publishers = new ArrayList<ContractReferencePublisher>();
        }
        try {
            StringReader config = new StringReader(configXml);
            if (ModelParser.getParser().validate(config)) {
                List<ServiceContract> modelServiceContracts;
                ByteArrayOutputStream listenerXml = new ByteArrayOutputStream();
                ByteArrayOutputStream gatewayXml = new ByteArrayOutputStream();
                Generator generator = new Generator(new ByteArrayInputStream(configXml.getBytes()), listenerXml, gatewayXml);
                generator.generate();
                byte[] listenerBytes = listenerXml.toByteArray();
                ByteArrayInputStream listenerIs = new ByteArrayInputStream(listenerBytes);
                ConfigTree listenerConfig = ConfigTree.fromInputStream(listenerIs);
                if (serviceName != null) {
                    listenerConfig.setAttribute("deployment", serviceName.getKeyProperty("deployment"));
                }
                List<ManagedLifecycle> instances = LifecycleUtil.getListeners(listenerConfig);
                byte[] gatewayBytes = gatewayXml.toByteArray();
                ByteArrayInputStream gatewayIs = new ByteArrayInputStream(gatewayBytes);
                ConfigTree gatewayConfig = ConfigTree.fromInputStream(gatewayIs);
                instances.addAll(LifecycleUtil.getGateways(gatewayConfig));
                ModelAdapter model = generator.getModel();
                if (servlets != null && !servlets.isEmpty() && (modelServiceContracts = model.getServiceContracts()) != null && modelServiceContracts.size() > 0) {
                    block5: for (Servlet servlet : servlets) {
                        Service service = servlet.getService();
                        String endpointAddress = servlet.getEndpointAddress();
                        if (service == null || endpointAddress == null) continue;
                        for (ServiceContract serviceContract : modelServiceContracts) {
                            if (!service.equals(serviceContract.getService())) continue;
                            publishers.add(new DefaultContractReferencePublisher(service, serviceContract.getDescription(), endpointAddress));
                            ContractProviderLifecycleResource.putContractProvider(service.getCategory(), service.getName(), serviceContract.getContractProvider());
                            continue block5;
                        }
                    }
                }
                ManagedLifecycleController controller = new ManagedLifecycleController(instances);
                boolean success = false;
                try {
                    ServicePublisher.addServicePublishers(controller, model.getServicePublishers());
                    ServicePublisher.addContractReferencePublishers(controller, publishers);
                    success = true;
                }
                finally {
                    if (!success) {
                        ServicePublisher.removeServicePublishers(controller);
                    }
                }
                return controller;
            }
            throw new IllegalStateException("ESB file had validation errors.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

