/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners;

import java.io.File;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.internal.soa.esb.util.Exit;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.lifecycle.LifecycleResourceManager;
import org.jboss.soa.esb.listeners.config.ConfigurationController;
import org.jboss.soa.esb.services.registry.RegistryFactory;

public class StandAloneBootStrapper {
    private ConfigurationController _confController;
    private static Logger _logger = Logger.getLogger(StandAloneBootStrapper.class);

    public static void main(String[] args) throws Exception {
        System.out.println("+----------------------------------------------------------+");
        System.out.println("|                                                          |");
        System.out.println("|     Starting JBossESB...                                 |");
        System.out.println("|                                                          |");
        System.out.println("+----------------------------------------------------------+");
        Exception eT = null;
        if (args.length < 1) {
            eT = new Exception("No configuration file specified - Ending immediately");
            _logger.fatal((Object)eT);
            throw eT;
        }
        String configName = args[0];
        File configFile = new File(configName);
        if (configFile.exists()) {
            System.out.println("Reading config from " + configFile.getAbsolutePath());
            String loggerConfig = configFile.getParent() + "/log4j.xml";
            DOMConfigurator.configure((String)loggerConfig);
        }
        long lSecondsToRun = 31536000L;
        if (args.length > 1) {
            try {
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if (arg.startsWith("exit-port=")) {
                        try {
                            int port = Integer.parseInt(arg.substring("exit-port=".length()));
                            Exit.startListener(port);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid exit port config '" + arg + "'.");
                        }
                        continue;
                    }
                    try {
                        lSecondsToRun = Long.parseLong(arg);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid 'secondst to run' time config '" + arg + "'.");
                    }
                }
            }
            catch (Exception e) {
                _logger.fatal((Object)e);
                throw e;
            }
        }
        final StandAloneBootStrapper boot = new StandAloneBootStrapper(configName);
        Thread hook = new Thread(){

            @Override
            public void run() {
                System.out.println("+----------------------------------------------------------+");
                System.out.println("|                                                          |");
                System.out.println("|     Stopping JBossESB...                                 |");
                System.out.println("|                                                          |");
                System.out.println("+----------------------------------------------------------+");
                boot.requestEnd();
                LifecycleResourceManager.getSingleton().cleanupAllResources();
            }
        };
        LifecycleResourceManager.deactivateHook();
        Runtime.getRuntime().addShutdownHook(hook);
        if (lSecondsToRun < 5L) {
            lSecondsToRun = 5L;
        }
        long lRunTo = System.currentTimeMillis() + 1000L * lSecondsToRun;
        while (System.currentTimeMillis() < lRunTo) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public StandAloneBootStrapper(String configName) throws ConfigurationException {
        this(configName, null);
    }

    public StandAloneBootStrapper(String configName, String validationFileName) throws ConfigurationException {
        System.setProperty("javax.xml.registry.ConnectionFactoryClass", "org.apache.ws.scout.registry.ConnectionFactoryImpl");
        this.runBefore();
        String listenerConfig = "jbossesb-listener.xml";
        String gatewayConfig = "jbossesb-gateway.xml";
        try {
            File configFile = new File(configName);
            String sParent = configFile.getParent();
            if (null == sParent) {
                sParent = new File("").getAbsolutePath();
            } else if (sParent.endsWith("/.") || sParent.endsWith("\\.")) {
                sParent = sParent.substring(0, -2 + sParent.length());
            }
            configFile = new File(sParent, configFile.getName());
            this._confController = this.initiateController(configFile.getAbsolutePath(), validationFileName, gatewayConfig, listenerConfig);
            _logger.info((Object)"Listeners Ready");
        }
        catch (ConfigurationException ex) {
            this.requestEnd();
            throw ex;
        }
        catch (Exception ex) {
            this.requestEnd();
            throw new ConfigurationException("Cannot instantiate " + this.getClass().getSimpleName(), ex);
        }
    }

    public void requestEnd() {
        if (this._confController != null) {
            this._confController.requestEnd();
            this._confController.waitUntilEnded();
        }
        this.runAfter();
    }

    protected void runBefore() {
    }

    protected void runAfter() {
    }

    public ConfigurationController initiateController(String configName, String validationName, String gwConf, String esbConf) throws ConfigurationException {
        File gatewayFile;
        File listenerFile;
        if (null == configName) {
            throw new IllegalArgumentException("Null configuration file specified");
        }
        try {
            RegistryFactory.setRegistry(RegistryFactory.createRegistry());
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to install Registry.", (Throwable)e);
        }
        File configFile = new File(configName);
        if (!configFile.exists()) {
            throw new IllegalArgumentException("Missing esb configuration file: " + configFile);
        }
        File configDir = configFile.getParentFile();
        if (null == configDir) {
            configDir = new File("");
        }
        if ((listenerFile = new File(configDir, esbConf)).exists()) {
            listenerFile.delete();
        }
        if ((gatewayFile = new File(configDir, gwConf)).exists()) {
            gatewayFile.delete();
        }
        ConfigurationController conf = new ConfigurationController(configFile.toString(), validationName);
        if (listenerFile.exists() && gatewayFile.exists()) {
            new Thread(conf).start();
            return conf;
        }
        throw new ConfigurationException("Unable to generate gateway and listener configurations");
    }
}

