/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners;

import com.arjuna.common.util.propertyservice.PropertyManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.util.EPRManager;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.services.registry.Registry;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.RegistryFactory;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;

public class RegistryUtil {
    private static final Logger logger = Logger.getLogger(RegistryUtil.class);
    private static final Lock registryLock = new ReentrantLock();

    public static EPRManager getEprManager() {
        PropertyManager manager = ModulePropertyManager.getPropertyManager("core");
        String dir = manager.getProperty("org.jboss.soa.esb.registry.file.directory", ".");
        return EPRManager.getInstance(dir);
    }

    private static void register(String name, EPR address) throws RegistryException {
        try {
            RegistryUtil.getEprManager().saveEPR(name, address);
        }
        catch (IOException ioe) {
            logger.error((Object)"Cannot register service", (Throwable)ioe);
            throw new RegistryException("Cannot register service", ioe);
        }
    }

    private static void unregister(String name) {
        try {
            RegistryUtil.getEprManager().removeEPR(name);
        }
        catch (IOException ioe) {
            logger.warn((Object)"Failed to unregister service", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(ConfigTree config, EPR epr) throws RegistryException {
        String category = config.getAttribute("service-category");
        String name = config.getAttribute("service-name");
        String removeOldService = config.getAttribute("remove-old-service");
        if ("eprManager".equalsIgnoreCase(category)) {
            RegistryUtil.register(name, epr);
        } else {
            String serviceDescription = config.getAttribute("service-description");
            String eprDescription = config.getAttribute("epr-description");
            Registry registry = RegistryFactory.getRegistry();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registering < " + name + ", " + epr + " >"));
            }
            registryLock.lock();
            try {
                if ("true".equalsIgnoreCase(removeOldService)) {
                    registry.unRegisterService(category, name);
                }
                registry.registerEPR(category, name, serviceDescription, epr, eprDescription);
            }
            catch (ServiceNotFoundException ex) {
                logger.debug((Object)("Could not unregister service < " + category + ", " + name + " >."));
            }
            finally {
                registryLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(String category, String name, EPR epr) {
        if ("eprManager".equalsIgnoreCase(category)) {
            RegistryUtil.unregister(name);
        } else {
            registryLock.lock();
            try {
                Registry registry = RegistryFactory.getRegistry();
                registry.unRegisterEPR(category, name, epr);
            }
            catch (ServiceNotFoundException snfe) {
                logger.warn((Object)"Failed to unregister service", (Throwable)snfe);
            }
            catch (RegistryException re) {
                logger.warn((Object)"Failed to unregister service", (Throwable)re);
            }
            finally {
                registryLock.unlock();
            }
        }
    }

    public static List<EPR> getEprs(String category, String name) throws RegistryException, ServiceNotFoundException {
        if ("eprManager".equalsIgnoreCase(category)) {
            EPR epr;
            try {
                epr = RegistryUtil.getEprManager().loadEPR(name);
            }
            catch (IOException ioe) {
                throw new RegistryException("No EPRs found for <" + category + "><" + name + ">");
            }
            return Arrays.asList(epr);
        }
        Registry reg = RegistryFactory.getRegistry();
        RegistryException eReg = null;
        for (int count = 0; count < 5; ++count) {
            try {
                return reg.findEPRs(category, name);
            }
            catch (RegistryException re) {
                if (null == eReg) {
                    eReg = re;
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException ie) {
                    break;
                }
            }
        }
        throw eReg;
    }
}

