/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.http.protocol.AbstractProtocolSocketFactoryBuilder;
import org.jboss.soa.esb.util.ssl.SSLUtil;
import org.jboss.soa.esb.util.ssl.SelfSignedTrustManager;

public class SelfSignedSSLProtocolSocketFactoryBuilder
extends AbstractProtocolSocketFactoryBuilder {
    @Override
    public ProtocolSocketFactory newInstance() throws ConfigurationException {
        try {
            return new SelfSignedSSLProtocolSocketFactory(this.getKeystore(), this.getKeystorePassword(), this.getTruststore());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConfigurationException("Failed to create SelfSignedSSLProtocolSocketFactory.", e);
        }
        catch (KeyStoreException e) {
            throw new ConfigurationException("Failed to create SelfSignedSSLProtocolSocketFactory.", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new ConfigurationException("Failed to create SelfSignedSSLProtocolSocketFactory.", e);
        }
    }

    private static class SelfSignedSSLProtocolSocketFactory
    implements SecureProtocolSocketFactory {
        private SSLContext sslContext;

        public SelfSignedSSLProtocolSocketFactory(KeyStore keystore, String keystorePassword, KeyStore truststore) throws NoSuchAlgorithmException, KeyStoreException, ConfigurationException, UnrecoverableKeyException {
            KeyManager[] keyManagers = SSLUtil.getKeyManagers(keystore, keystorePassword);
            SelfSignedTrustManager trustManager = new SelfSignedTrustManager(truststore);
            this.sslContext = SSLContext.getInstance("SSL");
            try {
                this.sslContext.init(keyManagers, new TrustManager[]{trustManager}, null);
            }
            catch (KeyManagementException e) {
                throw new ConfigurationException("Failed to initialize SSL Context.", e);
            }
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException {
            return this.sslContext.getSocketFactory().createSocket(host, port, clientHost, clientPort);
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, ConnectTimeoutException {
            AssertArgument.isNotNull(params, "params");
            SSLSocketFactory socketfactory = this.sslContext.getSocketFactory();
            int connectTimeout = params.getConnectionTimeout();
            if (connectTimeout == 0) {
                return socketfactory.createSocket(host, port, localAddress, localPort);
            }
            Socket socket = socketfactory.createSocket();
            InetSocketAddress localSocketAddress = new InetSocketAddress(localAddress, localPort);
            InetSocketAddress remoteSocketAddress = new InetSocketAddress(host, port);
            socket.bind(localSocketAddress);
            socket.connect(remoteSocketAddress, connectTimeout);
            return socket;
        }

        public Socket createSocket(String host, int port) throws IOException {
            return this.sslContext.getSocketFactory().createSocket(host, port);
        }
    }
}

