/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.http.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Properties;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.http.protocol.ProtocolSocketFactoryBuilder;
import org.jboss.soa.esb.util.ssl.SSLUtil;

public abstract class AbstractProtocolSocketFactoryBuilder
implements ProtocolSocketFactoryBuilder {
    private Properties configuration;

    @Override
    public void setConfiguration(Properties configuration) throws ConfigurationException {
        this.configuration = configuration;
    }

    protected String getTruststorePassword() {
        return this.configuration.getProperty("truststore-passw");
    }

    protected String getKeystorePassword() {
        return this.configuration.getProperty("keystore-passw");
    }

    protected String getKeystoreType() {
        return this.configuration.getProperty("keystore-type", "jks");
    }

    protected String getTruststoreType() {
        return this.configuration.getProperty("truststore-type", "jks");
    }

    protected URL getTruststoreURL() throws ConfigurationException {
        URL trustStoreURL = null;
        String trustStoreConfig = this.configuration.getProperty("truststore");
        if (trustStoreConfig != null) {
            try {
                trustStoreURL = new URL(trustStoreConfig);
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException("Invalid 'truststore' config.  Must be valid URL.", e);
            }
        }
        return trustStoreURL;
    }

    protected URL getKeystoreURL() throws ConfigurationException {
        String keyStoreConfig = this.configuration.getProperty("keystore");
        URL keyStoreURL = null;
        if (keyStoreConfig != null) {
            try {
                keyStoreURL = new URL(keyStoreConfig);
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException("Invalid 'keystore' config.  Must be valid URL.", e);
            }
        }
        return keyStoreURL;
    }

    protected KeyStore getKeystore() throws ConfigurationException {
        URL url = this.getKeystoreURL();
        if (url != null) {
            try {
                InputStream keystoreStream = url.openStream();
                if (keystoreStream != null) {
                    return SSLUtil.loadKeyStore(keystoreStream, this.getKeystoreType(), this.getKeystorePassword());
                }
                throw new ConfigurationException("Unable to open keystore '" + url.toString() + "' for loading.");
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to open keystore '" + url.toString() + "' for loading.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ConfigurationException("Unable to load keystore '" + url.toString() + "'.", e);
            }
            catch (KeyStoreException e) {
                throw new ConfigurationException("Unable to load keystore '" + url.toString() + "'.", e);
            }
            catch (CertificateException e) {
                throw new ConfigurationException("Unable to load keystore '" + url.toString() + "'.", e);
            }
        }
        return null;
    }

    protected KeyStore getTruststore() throws ConfigurationException {
        URL url = this.getTruststoreURL();
        if (url != null) {
            try {
                InputStream truststoreStream = url.openStream();
                if (truststoreStream != null) {
                    return SSLUtil.loadKeyStore(truststoreStream, this.getTruststoreType(), this.getTruststorePassword());
                }
                throw new ConfigurationException("Unable to open truststore '" + url.toString() + "' for loading.");
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to open truststore '" + url.toString() + "' for loading.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ConfigurationException("Unable to load truststore '" + url.toString() + "'.", e);
            }
            catch (KeyStoreException e) {
                throw new ConfigurationException("Unable to load truststore '" + url.toString() + "'.", e);
            }
            catch (CertificateException e) {
                throw new ConfigurationException("Unable to load truststore '" + url.toString() + "'.", e);
            }
        }
        return null;
    }
}

