/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.http.configurators;

import java.util.Properties;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.http.Configurator;

public class Connection
extends Configurator {
    public static final String MAX_TOTAL_CONNECTIONS = "max-total-connections";
    public static final String MAX_CONNECTIONS_PER_HOST = "max-connections-per-host";

    @Override
    public void configure(HttpClient httpClient, Properties properties) throws ConfigurationException {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        String maxTotalConnections = properties.getProperty(MAX_TOTAL_CONNECTIONS);
        String maxConnectionsPerHost = properties.getProperty(MAX_CONNECTIONS_PER_HOST);
        connectionManager.setParams((HttpConnectionManagerParams)new ESBHttpConnectionManagerParams(maxTotalConnections, maxConnectionsPerHost));
        httpClient.setHttpConnectionManager((HttpConnectionManager)connectionManager);
    }

    private static class ESBHttpConnectionManagerParams
    extends HttpConnectionManagerParams {
        private static final long serialVersionUID = 6586457118564628500L;
        private final Integer maxTotalConnections;
        private final Integer maxConnectionsPerHost;

        ESBHttpConnectionManagerParams(String totalConnections, String connectionsPerHost) throws ConfigurationException {
            if (totalConnections != null) {
                try {
                    this.maxTotalConnections = Integer.parseInt(totalConnections.trim());
                }
                catch (NumberFormatException nfe) {
                    throw new ConfigurationException("Invalid http.connection-manager.max-total property: " + totalConnections);
                }
            } else {
                this.maxTotalConnections = null;
            }
            if (connectionsPerHost != null) {
                try {
                    this.maxConnectionsPerHost = Integer.parseInt(connectionsPerHost.trim());
                }
                catch (NumberFormatException nfe) {
                    throw new ConfigurationException("Invalid max-connections-per-host property: " + connectionsPerHost);
                }
            } else {
                this.maxConnectionsPerHost = null;
            }
        }

        public int getMaxConnectionsPerHost(HostConfiguration hostConfiguration) {
            if (this.maxConnectionsPerHost != null) {
                return this.maxConnectionsPerHost;
            }
            return super.getMaxConnectionsPerHost(hostConfiguration);
        }

        public int getMaxTotalConnections() {
            if (this.maxTotalConnections != null) {
                return this.maxTotalConnections;
            }
            return super.getMaxTotalConnections();
        }
    }
}

