/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.http.configurators;

import java.util.Properties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.http.Configurator;

public class AuthNTLM
extends Configurator {
    @Override
    public void configure(HttpClient httpClient, Properties properties) throws ConfigurationException {
        String username = properties.getProperty("ntauth-username");
        String password = properties.getProperty("ntauth-password");
        String authScopeHost = properties.getProperty("ntauthscope-host");
        String authScopePort = properties.getProperty("ntauthscope-port");
        String authScopeRealm = properties.getProperty("ntauthscope-realm");
        String authScopeDomain = properties.getProperty("ntauthscope-domain");
        this.assertPropertySetAndNotBlank(username, "ntauth-username");
        this.assertPropertySetAndNotBlank(password, "ntauth-password");
        this.assertPropertySetAndNotBlank(authScopeHost, "ntauthscope-host");
        this.assertPropertyIsInteger(authScopePort, "ntauthscope-port");
        this.assertPropertySetAndNotBlank(authScopeDomain, "ntauthscope-domain");
        password = this.getPasswordFromFile(password);
        NTCredentials creds = new NTCredentials(username, password, authScopeHost, authScopeDomain);
        AuthScope authScope = authScopeRealm != null && !authScopeRealm.trim().equals("") ? new AuthScope(authScopeHost, Integer.parseInt(authScopePort), authScopeRealm) : new AuthScope(authScopeHost, Integer.parseInt(authScopePort));
        httpClient.getState().setCredentials(authScope, (Credentials)creds);
    }
}

