/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.http;

import java.security.Principal;
import java.util.HashSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.security.PublicCryptoUtil;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequestImpl;
import org.jboss.util.Base64;

public class HttpServletSecUtil {
    private static final Logger logger = Logger.getLogger(HttpServletSecUtil.class);

    public static boolean addAuthDetailsToMessage(HttpServletRequest request, Message message) throws ServletException {
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal != null) {
            AuthenticationRequest authRequest = HttpServletSecUtil.buildAuthenticationRequest(request);
            try {
                return PublicCryptoUtil.INSTANCE.addAuthRequestToMessage(authRequest, message);
            }
            catch (MessageDeliverException e) {
                throw new ServletException("Failed to attach AuthenticationRequest to ESB Message.", (Throwable)e);
            }
        }
        return false;
    }

    public static AuthenticationRequest buildAuthenticationRequest(HttpServletRequest req) {
        String authHeader = req.getHeader("Authorization");
        if (authHeader == null) {
            authHeader = req.getHeader("authorization");
        }
        if (authHeader != null) {
            if ("BASIC".equals(req.getAuthType())) {
                String bas64Data = authHeader.substring(authHeader.indexOf(32)).trim();
                String decodedData = new String(Base64.decode((String)bas64Data));
                String[] authTokens = decodedData.split(":");
                HashSet<Object> credentials = new HashSet<Object>();
                credentials.add(authTokens[1].toCharArray());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("User '" + authTokens[0] + "' authenticated by container using 'BASIC' auth.  Forwarding to ESB Service."));
                }
                return new AuthenticationRequestImpl.Builder(req.getUserPrincipal(), credentials).build();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication  method '" + req.getAuthType() + "' not supported for passing Authorization token to ESB Security."));
            }
        }
        return null;
    }
}

