/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.http;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.http.HttpHeader;
import org.jboss.soa.esb.message.Message;

public class HttpRequest
implements Serializable {
    private static final String REQUEST_KEY = HttpRequest.class.getName() + "#request";
    private String authType;
    private String characterEncoding;
    private String contentType;
    private String contextPath;
    private String localAddr;
    private String localName;
    private String method;
    private String pathInfo;
    private String protocol;
    private String queryString;
    private String remoteAddr;
    private String remoteHost;
    private String remoteUser;
    private int contentLength;
    private String requestSessionId;
    private String requestURI;
    private String scheme;
    private String serverName;
    private String requestPath;
    private List<String> pathInfoTokens = new ArrayList<String>();
    private Map<String, String[]> queryParams = new HashMap<String, String[]>();
    private List<HttpHeader> headers = new ArrayList<HttpHeader>();

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getRequestSessionId() {
        return this.requestSessionId;
    }

    public void setRequestSessionId(String requestSessionId) {
        this.requestSessionId = requestSessionId;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    public List<String> getPathInfoTokens() {
        return this.pathInfoTokens;
    }

    public Map<String, String[]> getQueryParams() {
        return this.queryParams;
    }

    public List<HttpHeader> getHeaders() {
        return this.headers;
    }

    public HttpHeader getHeader(String headerName) {
        for (HttpHeader header : this.headers) {
            if (!header.getName().equalsIgnoreCase(headerName)) continue;
            return header;
        }
        return null;
    }

    public String getHeaderValue(String headerName) {
        HttpHeader header = this.getHeader(headerName);
        return header != null ? header.getValue() : null;
    }

    public static HttpRequest getRequest(Message message) {
        AssertArgument.isNotNull(message, "message");
        return (HttpRequest)message.getProperties().getProperty(REQUEST_KEY);
    }

    public void setRequest(Message message) {
        AssertArgument.isNotNull(message, "message");
        message.getProperties().setProperty(REQUEST_KEY, this);
    }
}

