/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.http;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.soa.esb.common.Configuration;

public final class HttpConfiguration {
    private static final Logger logger = Logger.getLogger(HttpConfiguration.class);
    private static MBeanServer mbeanServer = null;

    private HttpConfiguration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MBeanServer getMBeanServer() {
        if (mbeanServer != null) return mbeanServer;
        Class<HttpConfiguration> clazz = HttpConfiguration.class;
        synchronized (HttpConfiguration.class) {
            if (mbeanServer != null) return mbeanServer;
            mbeanServer = MBeanServerLocator.locateJBoss();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mbeanServer;
        }
    }

    public static String getHost() {
        return HttpConfiguration.getHost("localhost");
    }

    public static String getHost(String defaultValue) {
        String global = Configuration.getHttpHost();
        if (global != null) {
            return global;
        }
        String bindAddress = Configuration.getBindAddress();
        if (bindAddress != null) {
            return bindAddress;
        }
        return defaultValue;
    }

    public static int getPort() {
        return HttpConfiguration.getPort(8080);
    }

    public static int getPort(int defaultValue) {
        String global = Configuration.getHttpPort();
        if (global != null) {
            return Integer.valueOf(global);
        }
        int port = HttpConfiguration.getConnectorPort("HTTP/1.1", false);
        if (port > -1) {
            return port;
        }
        return defaultValue;
    }

    public static int getSecurePort() {
        return HttpConfiguration.getSecurePort(8443);
    }

    public static int getSecurePort(int defaultValue) {
        String global = Configuration.getHttpSecurePort();
        if (global != null) {
            return Integer.valueOf(global);
        }
        int port = HttpConfiguration.getConnectorPort("HTTP/1.1", true);
        if (port > -1) {
            return port;
        }
        return defaultValue;
    }

    private static int getConnectorPort(String protocol, boolean secure) {
        int port = -1;
        try {
            MBeanServer mbs = HttpConfiguration.getMBeanServer();
            Set<ObjectName> connectorNames = mbs.queryNames(new ObjectName("jboss.web:type=Connector,*"), null);
            Iterator<ObjectName> i$ = connectorNames.iterator();
            while (i$.hasNext()) {
                ObjectName current;
                ObjectName currentName = current = i$.next();
                try {
                    int connectorPort = (Integer)mbs.getAttribute(currentName, "port");
                    boolean connectorSecure = (Boolean)mbs.getAttribute(currentName, "secure");
                    String connectorProtocol = (String)mbs.getAttribute(currentName, "protocol");
                    if (!protocol.equals(connectorProtocol) || secure != connectorSecure) continue;
                    if (port > -1) {
                        logger.warn((Object)("Found multiple connectors for protocol='" + protocol + "' and secure='" + secure + "', using first port found '" + port + "'"));
                        continue;
                    }
                    port = connectorPort;
                }
                catch (AttributeNotFoundException ignored) {}
            }
        }
        catch (JMException ignored) {
            port = -1;
        }
        return port;
    }

    public static String getAddress() {
        return HttpConfiguration.getAddress(null);
    }

    public static String getAddress(String path) {
        return HttpConfiguration.buildAddress(path, false);
    }

    public static String getSecureAddress() {
        return HttpConfiguration.getSecureAddress(null);
    }

    public static String getSecureAddress(String path) {
        return HttpConfiguration.buildAddress(path, true);
    }

    private static String buildAddress(String path, boolean secure) {
        StringBuilder sb = new StringBuilder();
        if (secure) {
            sb.append("https://");
            sb.append(HttpConfiguration.getHost());
            sb.append(":");
            sb.append(HttpConfiguration.getSecurePort());
        } else {
            sb.append("http://");
            sb.append(HttpConfiguration.getHost());
            sb.append(":");
            sb.append(HttpConfiguration.getPort());
        }
        if (path != null && (path = path.trim()).length() > 0) {
            if (!path.startsWith("/")) {
                sb.append("/");
            }
            sb.append(path);
        }
        return sb.toString();
    }

    public static URL getURL() throws MalformedURLException {
        return new URL(HttpConfiguration.getAddress());
    }

    public static URL getURL(String path) throws MalformedURLException {
        return new URL(HttpConfiguration.getAddress(path));
    }

    public static URL getSecureURL() throws MalformedURLException {
        return new URL(HttpConfiguration.getSecureAddress());
    }

    public static URL getSecureURL(String path) throws MalformedURLException {
        return new URL(HttpConfiguration.getSecureAddress(path));
    }

    public static URI getURI() throws URISyntaxException {
        return new URI(HttpConfiguration.getAddress());
    }

    public static URI getURI(String path) throws URISyntaxException {
        return new URI(HttpConfiguration.getAddress(path));
    }

    public static URI getSecureURI() throws URISyntaxException {
        return new URI(HttpConfiguration.getSecureAddress());
    }

    public static URI getSecureURI(String path) throws URISyntaxException {
        return new URI(HttpConfiguration.getSecureAddress(path));
    }

    public static URI createURI() {
        return URI.create(HttpConfiguration.getAddress());
    }

    public static URI createURI(String path) {
        return URI.create(HttpConfiguration.getAddress(path));
    }

    public static URI createSecureURI() {
        return URI.create(HttpConfiguration.getSecureAddress());
    }

    public static URI createSecureURI(String path) {
        return URI.create(HttpConfiguration.getSecureAddress(path));
    }

    public static boolean isResponseStatusEnabled() {
        return HttpConfiguration.isResponseStatusEnabled(true);
    }

    public static boolean isResponseStatusEnabled(boolean defaultValue) {
        String global = Configuration.getHttpResponseStatusEnabled();
        if (global != null) {
            return Boolean.valueOf(global);
        }
        return defaultValue;
    }
}

