/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.services.security.PasswordUtil;
import org.jboss.soa.esb.util.Util;

public class Email {
    private static Logger logger = Logger.getLogger(Email.class);
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String AUTH = "auth";
    public static final String FROM = "from";
    public static final String SENDTO = "sendTo";
    public static final String COPYTO = "ccTo";
    public static final String SUBJECT = "subject";
    public static final String ATTACH = "attachment";
    public static final String MESSAGE = "message";
    private String from = null;
    private String sendTo = null;
    private String copyTo = null;
    private String subject = null;
    private String[] attachments = null;
    private List<MimeBodyPart> attachmentParts = new ArrayList<MimeBodyPart>();
    private String message = null;
    private MimeMessage mailMessage;
    private final Session oMailSess;

    public Email() throws AddressException, MessagingException {
        this.oMailSess = this.initMailServerSession();
    }

    public Email(String host, int port, String username, String password, boolean auth) throws AddressException, MessagingException {
        AssertArgument.isNotNullAndNotEmpty(host, HOST);
        try {
            this.oMailSess = this.initMailServerSession(host, port, username, password, auth);
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    public void sendMessage() throws MessagingException {
        Transport.send((Message)this.getMailMessage());
    }

    public MimeMessage getMailMessage() throws MessagingException {
        if (this.mailMessage == null) {
            this.mailMessage = this.createMailMessage(this.oMailSess);
        }
        return this.mailMessage;
    }

    public String[] getAttachments() {
        return this.attachments;
    }

    public void setAttachments(String[] attachments) {
        this.attachments = attachments;
    }

    public void addAttachment(final InputStream is, final String attachmentName) throws MessagingException, IOException {
        MimeBodyPart part = new MimeBodyPart();
        part.setDataHandler(new DataHandler(new DataSource(){
            private ByteArrayOutputStream bos = new ByteArrayOutputStream();
            {
                int read;
                byte[] buff = new byte[8192];
                while ((read = is.read(buff)) != -1) {
                    this.bos.write(buff, 0, read);
                }
                this.bos.close();
            }

            public String getContentType() {
                return "application/octet-stream";
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(this.bos.toByteArray());
            }

            public String getName() {
                return attachmentName;
            }

            public OutputStream getOutputStream() throws IOException {
                throw new IOException("Cannot write to this read-only resource");
            }
        }));
        part.setFileName(attachmentName);
        this.attachmentParts.add(part);
    }

    public String getCopyTo() {
        return this.copyTo;
    }

    public void setCopyTo(String copyTo) {
        this.copyTo = copyTo;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getSendTo() {
        return this.sendTo;
    }

    public void setSendTo(String sendTo) {
        this.sendTo = sendTo;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private MimeMessage createMailMessage(Session oMailSess) throws AddressException, MessagingException {
        MimeMessage oMessage = new MimeMessage(oMailSess);
        this.addMessageAddressing(oMessage);
        this.addMessageSubject(oMessage);
        this.addMessageContent(oMessage);
        return oMessage;
    }

    private void addMessageAddressing(MimeMessage oMessage) throws AddressException, MessagingException {
        int i1;
        InternetAddress oFrom = new InternetAddress(this.from);
        oMessage.setFrom((Address)oFrom);
        oMessage.setReplyTo(new Address[]{oFrom});
        InternetAddress[] oaTo = InternetAddress.parse((String)this.sendTo);
        for (i1 = 0; i1 < oaTo.length; ++i1) {
            oMessage.addRecipient(MimeMessage.RecipientType.TO, (Address)oaTo[i1]);
        }
        if (null != this.copyTo) {
            oaTo = InternetAddress.parse((String)this.copyTo);
            for (i1 = 0; i1 < oaTo.length; ++i1) {
                oMessage.addRecipient(MimeMessage.RecipientType.CC, (Address)oaTo[i1]);
            }
        }
    }

    private void addMessageSubject(MimeMessage oMessage) throws MessagingException {
        if (null != this.subject) {
            oMessage.setSubject(this.subject);
        }
    }

    private void addMessageContent(MimeMessage oMessage) throws MessagingException {
        MimeBodyPart oBodyP = new MimeBodyPart();
        MimeMultipart oMultiP = new MimeMultipart();
        oMultiP.addBodyPart((BodyPart)oBodyP);
        oMessage.setContent((Multipart)oMultiP);
        if (null == this.message) {
            this.message = "";
        }
        oBodyP.setText(this.message + "\n");
        if (null != this.attachments) {
            for (int i1 = 0; i1 < this.attachments.length; ++i1) {
                oBodyP = new MimeBodyPart();
                oMultiP.addBodyPart((BodyPart)oBodyP);
                String sFile = this.attachments[i1];
                oBodyP.setDataHandler(new DataHandler((DataSource)new FileDataSource(sFile)));
                oBodyP.setFileName(sFile.substring(1 + sFile.lastIndexOf("\\")));
            }
        }
        for (MimeBodyPart part : this.attachmentParts) {
            oMultiP.addBodyPart((BodyPart)part);
        }
    }

    private Session initMailServerSession(String host, int port, String username, String password, boolean auth) throws IOException {
        MyAuth authenticator = null;
        if (!Util.isNullString(username)) {
            String pw = password;
            if (PasswordUtil.isPasswordFile(password)) {
                pw = new PasswordUtil(password).getPasswordAsString();
            }
            authenticator = new MyAuth(username, pw);
        }
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.host", host);
        properties.setProperty("mail.smtp.port", String.valueOf(port));
        properties.setProperty("mail.smtp.auth", String.valueOf(auth));
        logger.debug((Object)("Initialising mail server sesson. Properties: " + properties));
        return Session.getInstance((Properties)properties, (Authenticator)authenticator);
    }

    private Session initMailServerSession() {
        MyAuth oAuth = null;
        String sSmtpUser = Configuration.getSmtpUsername();
        if (!Util.isNullString(sSmtpUser)) {
            oAuth = new MyAuth(sSmtpUser, Configuration.getSmtpPassword());
        }
        Properties oMailP = new Properties();
        oMailP.setProperty("mail.smtp.host", Configuration.getSmtpHost());
        String sAuth = Configuration.getSmtpAuth();
        if (sAuth != null) {
            if (sAuth.trim().equals("")) {
                logger.warn((Object)"'org.jboss.soa.esb.mail.smtp.auth' set to an empty value.");
            }
            oMailP.setProperty("mail.smtp.auth", sAuth);
        }
        try {
            String sPort = Configuration.getSmtpPort();
            this.from = Configuration.getSmtpFrom();
            Integer.parseInt(sPort);
            oMailP.setProperty("mail.smtp.port", sPort);
        }
        catch (Exception e) {
            // empty catch block
        }
        logger.info((Object)("Initialising mail server sesson. Properties: " + oMailP));
        Session oMailSess = Session.getInstance((Properties)oMailP, (Authenticator)oAuth);
        return oMailSess;
    }

    private String[] getFileNamesAsArray(String attachments) {
        if (attachments.indexOf(44) != -1) {
            StringTokenizer st = new StringTokenizer(attachments, ",");
            String[] attachmentFileNames = new String[st.countTokens()];
            int index = 0;
            while (st.hasMoreTokens()) {
                attachmentFileNames[index] = st.nextToken();
                ++index;
            }
            return attachmentFileNames;
        }
        return new String[]{attachments};
    }

    private static class MyAuth
    extends Authenticator {
        private String m_sUser;
        private String m_sPwd;

        private MyAuth(String p_sU, String p_sP) {
            this.m_sUser = p_sU;
            this.m_sPwd = p_sP;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.m_sUser, this.m_sPwd);
        }
    }
}

